% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-string.r
\name{nameVectorN}
\alias{nameVectorN}
\title{define a named vector using vector names}
\usage{
nameVectorN(x, makeNamesFunc = makeNames, ...)
}
\arguments{
\item{x}{\code{character} vector or any object which has names available
\code{names(x)}.}

\item{makeNamesFunc}{\code{function} used to create unique names, in the event that
the names(x) are not unique.}

\item{...}{Additional arguments are ignored.}
}
\value{
vector of names, whose names are uniquely assigned using
\code{\link{makeNames}} using the values of the vector.
}
\description{
define a named vector using vector names
}
\details{
This function creates a vector from the names of the input vector,
then assigns the same as names. The utility is mainly for
\code{\link[base]{lapply}} functions which maintain the name of a vector
in its output. The reason to run \code{\link[base]{lapply}} using names
is so the lapply function is operating only on the name and not the
data it references, which can be convenient when the name of the element
is useful to known inside the function body. The reason to name the names,
is so the list object returned by \code{\link[base]{lapply}} is also named
with these same consistent names.

Consider a list of data.frames, each of which represents stats results
from a contrast and fold change. The data.frame may not indicate the name
of the contrast, while the list itself may be named by the contrast.
One would \code{lapply(nameVectorN(listDF), function(iName)iName)} which
allows the internal function access to the name of each list element. This
could for example be added to the data.frame.
}
\examples{
# a simple integer vector with character names
L <- nameVector(1:5, LETTERS[1:5]);
L;

# we can make a vector of names, retaining the names
nameVectorN(L);

# Now consider a named list, where the name is important
# to keep for downstream work.
K <- list(A=(1:3)^3, B=7:10, C=(1:4)^2);
K;
# Typical lapply-style work does not operate on the name,
# making it difficult to use the name inside the function.
# Here, we just add the name to the colnames, but anything
# could be useful.
lapply(K, function(i){
    data.frame(mean=mean(i), median=stats::median(i));
 });

# So the next step is to run lapply() on the names
lapply(names(K), function(i){
   iDF <- data.frame(mean=mean(K[[i]]), median=stats::median(K[[i]]));
   colnames(iDF) <- paste(c("mean", "median"), i);
   iDF;
})
# The result is good, but the list is no longer named.
# The nameVectorN() function is helpful for maintaining the names.

# So we run lapply() on the named-names, which keeps the names in
# the resulting list, and sends it into the function.
lapply(nameVectorN(K), function(i){
   iDF <- data.frame(mean=mean(K[[i]]), median=stats::median(K[[i]]));
   colnames(iDF) <- paste(c("mean", "median"), i);
   iDF;
});

}
\seealso{
Other jam string functions: 
\code{\link{asSize}()},
\code{\link{breaksByVector}()},
\code{\link{fillBlanks}()},
\code{\link{formatInt}()},
\code{\link{gsubOrdered}()},
\code{\link{gsubs}()},
\code{\link{makeNames}()},
\code{\link{nameVector}()},
\code{\link{padInteger}()},
\code{\link{padString}()},
\code{\link{pasteByRow}()},
\code{\link{pasteByRowOrdered}()},
\code{\link{sizeAsNum}()},
\code{\link{tcount}()},
\code{\link{ucfirst}()}
}
\concept{jam string functions}
