% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba.r
\name{getDate}
\alias{getDate}
\title{get simple date string}
\usage{
getDate(t = Sys.time(), trim = TRUE, dateFormat = "\%d\%b\%Y", ...)
}
\arguments{
\item{t}{current time in an appropriate class such as \code{"POSIXct"}
or \code{"POSIXt"}. The default is output of \code{Sys.time()}.}

\item{trim}{\code{logical} whether to trim the output of \code{format()}
in the event that multiple values are sent for argument \code{t}.}

\item{dateFormat}{\code{character} string representing the recognized date
format, by default \code{"DDmmmYYYY"}, which recognizes \code{"23aug2007"}.}

\item{...}{additional parameters sent to \code{format()}.}
}
\value{
\code{character} vector with simplified date string
}
\description{
get simple date string in the format DDmonYYYY such as 17jul2018.
}
\details{
Gets the current date in a simplified text string. Use
\code{asDate()} to convert back to Date object.
}
\examples{
getDate();

}
\seealso{
Other jam date functions: 
\code{\link{asDate}()},
\code{\link{dateToDaysOld}()}
}
\concept{jam date functions}
