% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-export.r
\name{applyXlsxCategoricalFormat}
\alias{applyXlsxCategoricalFormat}
\title{Add categorical colors to 'Excel' 'xlsx' worksheets}
\usage{
applyXlsxCategoricalFormat(
  xlsxFile,
  sheet = 1,
  rowRange = NULL,
  colRange = NULL,
  colorSub = NULL,
  colorSubText = setTextContrastColor(colorSub),
  trimCatNames = TRUE,
  overwrite = TRUE,
  wrapText = FALSE,
  stack = TRUE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{xlsxFile}{\code{character} filename to a file with ".xlsx" extension,
or \code{Workbook} object defined in the \code{openxlsx} package. When
\code{xlsxFile} is a \code{Workbook} the output is not saved to a file.}

\item{sheet}{\code{integer} index of the worksheet or worksheets.}

\item{rowRange, colRange}{\code{integer} vectors of rows and columns
to apply categorical colors in the 'Excel' 'xlsx' worksheet,
passed as \code{openxlsx::readWorkbook(..., rows=rowRange, cols=colRange)}.
This step defines which columns are read from each workbook,
however when \code{colorSub} is provided as a \code{list} whose names
are intended to match \code{colnames()}, only matching colnames
are processed.}

\item{colorSub}{one of the following types of input:
\itemize{
\item Named \code{character} vector of valid R colors, whose
names correspond to values in worksheet cells.
\item Named \code{list} whose names correspond to colnames one or more
workbooks in \code{sheet}. Each list element should be a \code{character}
vector named by column values, or color \code{function} that takes
column values and returns a \code{character} vector of colors for
each value.
}}

\item{colorSubText}{optional \code{character} vector of colors, whose
names correspond to values in the worksheet cells. In
absence of a specific text color, \code{setTextContrastColor()}
is used to define a contrasting text color to be visible on
the colored background.}

\item{trimCatNames}{\code{logical} whether to trim whitespace and punctuation
from \code{colorSub} and from 'Excel' cell fields before matching colors
to 'Excel' values.}

\item{overwrite}{\code{logical} indicating whether new cell color styles
should be forced overwrite of previous cell styles.}

\item{wrapText}{\code{logical} indicating whether to wrap text.}

\item{stack}{\code{logical} indicating whether new color rules should be
applied above existing styles, many of whose styles may not affect
the specific cell color, for example the font size and font name.}

\item{verbose}{\code{logical} indicating whether to print verbose output.}

\item{...}{additional arguments are ignored.}
}
\value{
\code{Workbook} object as defined by the \code{openxlsx} package
is returned invisibly with \code{invisible()}. This \code{Workbook}
can be used in argument \code{wb} to provide a speed boost when
saving multiple sheets to the same file.
}
\description{
Add categorical colors to 'Excel' 'xlsx' worksheets
}
\details{
This function is a convenient wrapper for applying categorical
color formatting to cell background colors, and applies a contrasting
color to the text in cells using \code{setTextContrastColor()}.
It uses a named character vector of colors supplied as \code{colorSub}
to define cell background colors, and optionally \code{colorSubText}
to define a specific color for the cell text.
}
\examples{
# write to tempfile for examples
if (check_pkg_installed("openxlsx")) {
   out_xlsx <- tempfile(pattern="writeOpenxlsx_", fileext=".xlsx")
   df <- data.frame(a=LETTERS[1:5], b=1:5);
   writeOpenxlsx(x=df,
      file=out_xlsx,
      sheetName="jamba_test");

   colorSub <- nameVector(
      rainbow2(5, s=c(0.8, 1), v=c(0.8, 1)),
      LETTERS[1:5]);
   applyXlsxCategoricalFormat(out_xlsx,
      sheet="jamba_test",
      colorSub=colorSub
   )
}

}
\seealso{
Other jam export functions: 
\code{\link{applyXlsxConditionalFormat}()},
\code{\link{readOpenxlsx}()},
\code{\link{set_xlsx_colwidths}()},
\code{\link{set_xlsx_rowheights}()},
\code{\link{writeOpenxlsx}()}
}
\concept{jam export functions}
