// Generated by using Rcpp::compileAttributes() -> do not edit by hand
// Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#include "jackalope_types.h"
#include <RcppArmadillo.h>
#include <Rcpp.h>

using namespace Rcpp;

// merge_all_chromosomes_cpp
void merge_all_chromosomes_cpp(SEXP ref_genome_ptr);
RcppExport SEXP _jackalope_merge_all_chromosomes_cpp(SEXP ref_genome_ptrSEXP) {
BEGIN_RCPP
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP >::type ref_genome_ptr(ref_genome_ptrSEXP);
    merge_all_chromosomes_cpp(ref_genome_ptr);
    return R_NilValue;
END_RCPP
}
// merge_chromosomes_cpp
void merge_chromosomes_cpp(SEXP ref_genome_ptr, std::deque<uint64> chrom_inds);
RcppExport SEXP _jackalope_merge_chromosomes_cpp(SEXP ref_genome_ptrSEXP, SEXP chrom_indsSEXP) {
BEGIN_RCPP
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP >::type ref_genome_ptr(ref_genome_ptrSEXP);
    Rcpp::traits::input_parameter< std::deque<uint64> >::type chrom_inds(chrom_indsSEXP);
    merge_chromosomes_cpp(ref_genome_ptr, chrom_inds);
    return R_NilValue;
END_RCPP
}
// filter_chromosomes_cpp
void filter_chromosomes_cpp(SEXP ref_genome_ptr, const uint64& min_chrom_size, const double& out_chrom_prop);
RcppExport SEXP _jackalope_filter_chromosomes_cpp(SEXP ref_genome_ptrSEXP, SEXP min_chrom_sizeSEXP, SEXP out_chrom_propSEXP) {
BEGIN_RCPP
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP >::type ref_genome_ptr(ref_genome_ptrSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type min_chrom_size(min_chrom_sizeSEXP);
    Rcpp::traits::input_parameter< const double& >::type out_chrom_prop(out_chrom_propSEXP);
    filter_chromosomes_cpp(ref_genome_ptr, min_chrom_size, out_chrom_prop);
    return R_NilValue;
END_RCPP
}
// replace_Ns_cpp
void replace_Ns_cpp(SEXP ref_genome_ptr, const std::vector<double>& pi_tcag, uint64 n_threads, const bool& show_progress);
RcppExport SEXP _jackalope_replace_Ns_cpp(SEXP ref_genome_ptrSEXP, SEXP pi_tcagSEXP, SEXP n_threadsSEXP, SEXP show_progressSEXP) {
BEGIN_RCPP
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP >::type ref_genome_ptr(ref_genome_ptrSEXP);
    Rcpp::traits::input_parameter< const std::vector<double>& >::type pi_tcag(pi_tcagSEXP);
    Rcpp::traits::input_parameter< uint64 >::type n_threads(n_threadsSEXP);
    Rcpp::traits::input_parameter< const bool& >::type show_progress(show_progressSEXP);
    replace_Ns_cpp(ref_genome_ptr, pi_tcag, n_threads, show_progress);
    return R_NilValue;
END_RCPP
}
// create_genome_cpp
SEXP create_genome_cpp(const uint64& n_chroms, const double& len_mean, const double& len_sd, std::vector<double> pi_tcag, const uint64& n_threads);
RcppExport SEXP _jackalope_create_genome_cpp(SEXP n_chromsSEXP, SEXP len_meanSEXP, SEXP len_sdSEXP, SEXP pi_tcagSEXP, SEXP n_threadsSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const uint64& >::type n_chroms(n_chromsSEXP);
    Rcpp::traits::input_parameter< const double& >::type len_mean(len_meanSEXP);
    Rcpp::traits::input_parameter< const double& >::type len_sd(len_sdSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type pi_tcag(pi_tcagSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type n_threads(n_threadsSEXP);
    rcpp_result_gen = Rcpp::wrap(create_genome_cpp(n_chroms, len_mean, len_sd, pi_tcag, n_threads));
    return rcpp_result_gen;
END_RCPP
}
// rando_chroms
std::vector<std::string> rando_chroms(const uint64& n_chroms, const double& len_mean, const double& len_sd, NumericVector pi_tcag, const uint64& n_threads);
RcppExport SEXP _jackalope_rando_chroms(SEXP n_chromsSEXP, SEXP len_meanSEXP, SEXP len_sdSEXP, SEXP pi_tcagSEXP, SEXP n_threadsSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const uint64& >::type n_chroms(n_chromsSEXP);
    Rcpp::traits::input_parameter< const double& >::type len_mean(len_meanSEXP);
    Rcpp::traits::input_parameter< const double& >::type len_sd(len_sdSEXP);
    Rcpp::traits::input_parameter< NumericVector >::type pi_tcag(pi_tcagSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type n_threads(n_threadsSEXP);
    rcpp_result_gen = Rcpp::wrap(rando_chroms(n_chroms, len_mean, len_sd, pi_tcag, n_threads));
    return rcpp_result_gen;
END_RCPP
}
// add_ssites_cpp
SEXP add_ssites_cpp(SEXP& ref_genome_ptr, const std::vector<arma::mat>& seg_sites, const arma::mat& Q, const std::vector<double>& pi_tcag, const std::vector<double>& insertion_rates, const std::vector<double>& deletion_rates, uint64 n_threads, const bool& show_progress);
RcppExport SEXP _jackalope_add_ssites_cpp(SEXP ref_genome_ptrSEXP, SEXP seg_sitesSEXP, SEXP QSEXP, SEXP pi_tcagSEXP, SEXP insertion_ratesSEXP, SEXP deletion_ratesSEXP, SEXP n_threadsSEXP, SEXP show_progressSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP& >::type ref_genome_ptr(ref_genome_ptrSEXP);
    Rcpp::traits::input_parameter< const std::vector<arma::mat>& >::type seg_sites(seg_sitesSEXP);
    Rcpp::traits::input_parameter< const arma::mat& >::type Q(QSEXP);
    Rcpp::traits::input_parameter< const std::vector<double>& >::type pi_tcag(pi_tcagSEXP);
    Rcpp::traits::input_parameter< const std::vector<double>& >::type insertion_rates(insertion_ratesSEXP);
    Rcpp::traits::input_parameter< const std::vector<double>& >::type deletion_rates(deletion_ratesSEXP);
    Rcpp::traits::input_parameter< uint64 >::type n_threads(n_threadsSEXP);
    Rcpp::traits::input_parameter< const bool& >::type show_progress(show_progressSEXP);
    rcpp_result_gen = Rcpp::wrap(add_ssites_cpp(ref_genome_ptr, seg_sites, Q, pi_tcag, insertion_rates, deletion_rates, n_threads, show_progress));
    return rcpp_result_gen;
END_RCPP
}
// illumina_ref_cpp
void illumina_ref_cpp(SEXP ref_genome_ptr, const bool& paired, const bool& matepair, const std::string& out_prefix, const int& compress, const std::string& comp_method, const uint64& n_reads, const double& prob_dup, const uint64& n_threads, const bool& show_progress, const uint64& read_pool_size, const double& frag_len_shape, const double& frag_len_scale, const uint64& frag_len_min, const uint64& frag_len_max, const std::vector<std::vector<std::vector<double>>>& qual_probs1, const std::vector<std::vector<std::vector<uint8>>>& quals1, const double& ins_prob1, const double& del_prob1, const std::vector<std::vector<std::vector<double>>>& qual_probs2, const std::vector<std::vector<std::vector<uint8>>>& quals2, const double& ins_prob2, const double& del_prob2, const std::vector<std::string>& barcodes);
RcppExport SEXP _jackalope_illumina_ref_cpp(SEXP ref_genome_ptrSEXP, SEXP pairedSEXP, SEXP matepairSEXP, SEXP out_prefixSEXP, SEXP compressSEXP, SEXP comp_methodSEXP, SEXP n_readsSEXP, SEXP prob_dupSEXP, SEXP n_threadsSEXP, SEXP show_progressSEXP, SEXP read_pool_sizeSEXP, SEXP frag_len_shapeSEXP, SEXP frag_len_scaleSEXP, SEXP frag_len_minSEXP, SEXP frag_len_maxSEXP, SEXP qual_probs1SEXP, SEXP quals1SEXP, SEXP ins_prob1SEXP, SEXP del_prob1SEXP, SEXP qual_probs2SEXP, SEXP quals2SEXP, SEXP ins_prob2SEXP, SEXP del_prob2SEXP, SEXP barcodesSEXP) {
BEGIN_RCPP
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP >::type ref_genome_ptr(ref_genome_ptrSEXP);
    Rcpp::traits::input_parameter< const bool& >::type paired(pairedSEXP);
    Rcpp::traits::input_parameter< const bool& >::type matepair(matepairSEXP);
    Rcpp::traits::input_parameter< const std::string& >::type out_prefix(out_prefixSEXP);
    Rcpp::traits::input_parameter< const int& >::type compress(compressSEXP);
    Rcpp::traits::input_parameter< const std::string& >::type comp_method(comp_methodSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type n_reads(n_readsSEXP);
    Rcpp::traits::input_parameter< const double& >::type prob_dup(prob_dupSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type n_threads(n_threadsSEXP);
    Rcpp::traits::input_parameter< const bool& >::type show_progress(show_progressSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type read_pool_size(read_pool_sizeSEXP);
    Rcpp::traits::input_parameter< const double& >::type frag_len_shape(frag_len_shapeSEXP);
    Rcpp::traits::input_parameter< const double& >::type frag_len_scale(frag_len_scaleSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type frag_len_min(frag_len_minSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type frag_len_max(frag_len_maxSEXP);
    Rcpp::traits::input_parameter< const std::vector<std::vector<std::vector<double>>>& >::type qual_probs1(qual_probs1SEXP);
    Rcpp::traits::input_parameter< const std::vector<std::vector<std::vector<uint8>>>& >::type quals1(quals1SEXP);
    Rcpp::traits::input_parameter< const double& >::type ins_prob1(ins_prob1SEXP);
    Rcpp::traits::input_parameter< const double& >::type del_prob1(del_prob1SEXP);
    Rcpp::traits::input_parameter< const std::vector<std::vector<std::vector<double>>>& >::type qual_probs2(qual_probs2SEXP);
    Rcpp::traits::input_parameter< const std::vector<std::vector<std::vector<uint8>>>& >::type quals2(quals2SEXP);
    Rcpp::traits::input_parameter< const double& >::type ins_prob2(ins_prob2SEXP);
    Rcpp::traits::input_parameter< const double& >::type del_prob2(del_prob2SEXP);
    Rcpp::traits::input_parameter< const std::vector<std::string>& >::type barcodes(barcodesSEXP);
    illumina_ref_cpp(ref_genome_ptr, paired, matepair, out_prefix, compress, comp_method, n_reads, prob_dup, n_threads, show_progress, read_pool_size, frag_len_shape, frag_len_scale, frag_len_min, frag_len_max, qual_probs1, quals1, ins_prob1, del_prob1, qual_probs2, quals2, ins_prob2, del_prob2, barcodes);
    return R_NilValue;
END_RCPP
}
// illumina_hap_cpp
void illumina_hap_cpp(SEXP hap_set_ptr, const bool& paired, const bool& matepair, const std::string& out_prefix, const bool& sep_files, const int& compress, const std::string& comp_method, const uint64& n_reads, const double& prob_dup, const uint64& n_threads, const bool& show_progress, const uint64& read_pool_size, const std::vector<double>& haplotype_probs, const double& frag_len_shape, const double& frag_len_scale, const uint64& frag_len_min, const uint64& frag_len_max, const std::vector<std::vector<std::vector<double>>>& qual_probs1, const std::vector<std::vector<std::vector<uint8>>>& quals1, const double& ins_prob1, const double& del_prob1, const std::vector<std::vector<std::vector<double>>>& qual_probs2, const std::vector<std::vector<std::vector<uint8>>>& quals2, const double& ins_prob2, const double& del_prob2, const std::vector<std::string>& barcodes);
RcppExport SEXP _jackalope_illumina_hap_cpp(SEXP hap_set_ptrSEXP, SEXP pairedSEXP, SEXP matepairSEXP, SEXP out_prefixSEXP, SEXP sep_filesSEXP, SEXP compressSEXP, SEXP comp_methodSEXP, SEXP n_readsSEXP, SEXP prob_dupSEXP, SEXP n_threadsSEXP, SEXP show_progressSEXP, SEXP read_pool_sizeSEXP, SEXP haplotype_probsSEXP, SEXP frag_len_shapeSEXP, SEXP frag_len_scaleSEXP, SEXP frag_len_minSEXP, SEXP frag_len_maxSEXP, SEXP qual_probs1SEXP, SEXP quals1SEXP, SEXP ins_prob1SEXP, SEXP del_prob1SEXP, SEXP qual_probs2SEXP, SEXP quals2SEXP, SEXP ins_prob2SEXP, SEXP del_prob2SEXP, SEXP barcodesSEXP) {
BEGIN_RCPP
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP >::type hap_set_ptr(hap_set_ptrSEXP);
    Rcpp::traits::input_parameter< const bool& >::type paired(pairedSEXP);
    Rcpp::traits::input_parameter< const bool& >::type matepair(matepairSEXP);
    Rcpp::traits::input_parameter< const std::string& >::type out_prefix(out_prefixSEXP);
    Rcpp::traits::input_parameter< const bool& >::type sep_files(sep_filesSEXP);
    Rcpp::traits::input_parameter< const int& >::type compress(compressSEXP);
    Rcpp::traits::input_parameter< const std::string& >::type comp_method(comp_methodSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type n_reads(n_readsSEXP);
    Rcpp::traits::input_parameter< const double& >::type prob_dup(prob_dupSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type n_threads(n_threadsSEXP);
    Rcpp::traits::input_parameter< const bool& >::type show_progress(show_progressSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type read_pool_size(read_pool_sizeSEXP);
    Rcpp::traits::input_parameter< const std::vector<double>& >::type haplotype_probs(haplotype_probsSEXP);
    Rcpp::traits::input_parameter< const double& >::type frag_len_shape(frag_len_shapeSEXP);
    Rcpp::traits::input_parameter< const double& >::type frag_len_scale(frag_len_scaleSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type frag_len_min(frag_len_minSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type frag_len_max(frag_len_maxSEXP);
    Rcpp::traits::input_parameter< const std::vector<std::vector<std::vector<double>>>& >::type qual_probs1(qual_probs1SEXP);
    Rcpp::traits::input_parameter< const std::vector<std::vector<std::vector<uint8>>>& >::type quals1(quals1SEXP);
    Rcpp::traits::input_parameter< const double& >::type ins_prob1(ins_prob1SEXP);
    Rcpp::traits::input_parameter< const double& >::type del_prob1(del_prob1SEXP);
    Rcpp::traits::input_parameter< const std::vector<std::vector<std::vector<double>>>& >::type qual_probs2(qual_probs2SEXP);
    Rcpp::traits::input_parameter< const std::vector<std::vector<std::vector<uint8>>>& >::type quals2(quals2SEXP);
    Rcpp::traits::input_parameter< const double& >::type ins_prob2(ins_prob2SEXP);
    Rcpp::traits::input_parameter< const double& >::type del_prob2(del_prob2SEXP);
    Rcpp::traits::input_parameter< const std::vector<std::string>& >::type barcodes(barcodesSEXP);
    illumina_hap_cpp(hap_set_ptr, paired, matepair, out_prefix, sep_files, compress, comp_method, n_reads, prob_dup, n_threads, show_progress, read_pool_size, haplotype_probs, frag_len_shape, frag_len_scale, frag_len_min, frag_len_max, qual_probs1, quals1, ins_prob1, del_prob1, qual_probs2, quals2, ins_prob2, del_prob2, barcodes);
    return R_NilValue;
END_RCPP
}
// pacbio_ref_cpp
void pacbio_ref_cpp(SEXP ref_genome_ptr, const std::string& out_prefix, const int& compress, const std::string& comp_method, const uint64& n_reads, const uint64& n_threads, const bool& show_progress, const uint64& read_pool_size, const double& prob_dup, const double& scale, const double& sigma, const double& loc, const double& min_read_len, const std::vector<double>& read_probs, const std::vector<uint64>& read_lens, const uint64& max_passes, const std::vector<double>& chi2_params_n, const std::vector<double>& chi2_params_s, const std::vector<double>& sqrt_params, const std::vector<double>& norm_params, const double& prob_thresh, const double& prob_ins, const double& prob_del, const double& prob_subst);
RcppExport SEXP _jackalope_pacbio_ref_cpp(SEXP ref_genome_ptrSEXP, SEXP out_prefixSEXP, SEXP compressSEXP, SEXP comp_methodSEXP, SEXP n_readsSEXP, SEXP n_threadsSEXP, SEXP show_progressSEXP, SEXP read_pool_sizeSEXP, SEXP prob_dupSEXP, SEXP scaleSEXP, SEXP sigmaSEXP, SEXP locSEXP, SEXP min_read_lenSEXP, SEXP read_probsSEXP, SEXP read_lensSEXP, SEXP max_passesSEXP, SEXP chi2_params_nSEXP, SEXP chi2_params_sSEXP, SEXP sqrt_paramsSEXP, SEXP norm_paramsSEXP, SEXP prob_threshSEXP, SEXP prob_insSEXP, SEXP prob_delSEXP, SEXP prob_substSEXP) {
BEGIN_RCPP
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP >::type ref_genome_ptr(ref_genome_ptrSEXP);
    Rcpp::traits::input_parameter< const std::string& >::type out_prefix(out_prefixSEXP);
    Rcpp::traits::input_parameter< const int& >::type compress(compressSEXP);
    Rcpp::traits::input_parameter< const std::string& >::type comp_method(comp_methodSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type n_reads(n_readsSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type n_threads(n_threadsSEXP);
    Rcpp::traits::input_parameter< const bool& >::type show_progress(show_progressSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type read_pool_size(read_pool_sizeSEXP);
    Rcpp::traits::input_parameter< const double& >::type prob_dup(prob_dupSEXP);
    Rcpp::traits::input_parameter< const double& >::type scale(scaleSEXP);
    Rcpp::traits::input_parameter< const double& >::type sigma(sigmaSEXP);
    Rcpp::traits::input_parameter< const double& >::type loc(locSEXP);
    Rcpp::traits::input_parameter< const double& >::type min_read_len(min_read_lenSEXP);
    Rcpp::traits::input_parameter< const std::vector<double>& >::type read_probs(read_probsSEXP);
    Rcpp::traits::input_parameter< const std::vector<uint64>& >::type read_lens(read_lensSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type max_passes(max_passesSEXP);
    Rcpp::traits::input_parameter< const std::vector<double>& >::type chi2_params_n(chi2_params_nSEXP);
    Rcpp::traits::input_parameter< const std::vector<double>& >::type chi2_params_s(chi2_params_sSEXP);
    Rcpp::traits::input_parameter< const std::vector<double>& >::type sqrt_params(sqrt_paramsSEXP);
    Rcpp::traits::input_parameter< const std::vector<double>& >::type norm_params(norm_paramsSEXP);
    Rcpp::traits::input_parameter< const double& >::type prob_thresh(prob_threshSEXP);
    Rcpp::traits::input_parameter< const double& >::type prob_ins(prob_insSEXP);
    Rcpp::traits::input_parameter< const double& >::type prob_del(prob_delSEXP);
    Rcpp::traits::input_parameter< const double& >::type prob_subst(prob_substSEXP);
    pacbio_ref_cpp(ref_genome_ptr, out_prefix, compress, comp_method, n_reads, n_threads, show_progress, read_pool_size, prob_dup, scale, sigma, loc, min_read_len, read_probs, read_lens, max_passes, chi2_params_n, chi2_params_s, sqrt_params, norm_params, prob_thresh, prob_ins, prob_del, prob_subst);
    return R_NilValue;
END_RCPP
}
// pacbio_hap_cpp
void pacbio_hap_cpp(SEXP hap_set_ptr, const std::string& out_prefix, const bool& sep_files, const int& compress, const std::string& comp_method, const uint64& n_reads, const uint64& n_threads, const bool& show_progress, const uint64& read_pool_size, const std::vector<double>& haplotype_probs, const double& prob_dup, const double& scale, const double& sigma, const double& loc, const double& min_read_len, const std::vector<double>& read_probs, const std::vector<uint64>& read_lens, const uint64& max_passes, const std::vector<double>& chi2_params_n, const std::vector<double>& chi2_params_s, const std::vector<double>& sqrt_params, const std::vector<double>& norm_params, const double& prob_thresh, const double& prob_ins, const double& prob_del, const double& prob_subst);
RcppExport SEXP _jackalope_pacbio_hap_cpp(SEXP hap_set_ptrSEXP, SEXP out_prefixSEXP, SEXP sep_filesSEXP, SEXP compressSEXP, SEXP comp_methodSEXP, SEXP n_readsSEXP, SEXP n_threadsSEXP, SEXP show_progressSEXP, SEXP read_pool_sizeSEXP, SEXP haplotype_probsSEXP, SEXP prob_dupSEXP, SEXP scaleSEXP, SEXP sigmaSEXP, SEXP locSEXP, SEXP min_read_lenSEXP, SEXP read_probsSEXP, SEXP read_lensSEXP, SEXP max_passesSEXP, SEXP chi2_params_nSEXP, SEXP chi2_params_sSEXP, SEXP sqrt_paramsSEXP, SEXP norm_paramsSEXP, SEXP prob_threshSEXP, SEXP prob_insSEXP, SEXP prob_delSEXP, SEXP prob_substSEXP) {
BEGIN_RCPP
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP >::type hap_set_ptr(hap_set_ptrSEXP);
    Rcpp::traits::input_parameter< const std::string& >::type out_prefix(out_prefixSEXP);
    Rcpp::traits::input_parameter< const bool& >::type sep_files(sep_filesSEXP);
    Rcpp::traits::input_parameter< const int& >::type compress(compressSEXP);
    Rcpp::traits::input_parameter< const std::string& >::type comp_method(comp_methodSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type n_reads(n_readsSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type n_threads(n_threadsSEXP);
    Rcpp::traits::input_parameter< const bool& >::type show_progress(show_progressSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type read_pool_size(read_pool_sizeSEXP);
    Rcpp::traits::input_parameter< const std::vector<double>& >::type haplotype_probs(haplotype_probsSEXP);
    Rcpp::traits::input_parameter< const double& >::type prob_dup(prob_dupSEXP);
    Rcpp::traits::input_parameter< const double& >::type scale(scaleSEXP);
    Rcpp::traits::input_parameter< const double& >::type sigma(sigmaSEXP);
    Rcpp::traits::input_parameter< const double& >::type loc(locSEXP);
    Rcpp::traits::input_parameter< const double& >::type min_read_len(min_read_lenSEXP);
    Rcpp::traits::input_parameter< const std::vector<double>& >::type read_probs(read_probsSEXP);
    Rcpp::traits::input_parameter< const std::vector<uint64>& >::type read_lens(read_lensSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type max_passes(max_passesSEXP);
    Rcpp::traits::input_parameter< const std::vector<double>& >::type chi2_params_n(chi2_params_nSEXP);
    Rcpp::traits::input_parameter< const std::vector<double>& >::type chi2_params_s(chi2_params_sSEXP);
    Rcpp::traits::input_parameter< const std::vector<double>& >::type sqrt_params(sqrt_paramsSEXP);
    Rcpp::traits::input_parameter< const std::vector<double>& >::type norm_params(norm_paramsSEXP);
    Rcpp::traits::input_parameter< const double& >::type prob_thresh(prob_threshSEXP);
    Rcpp::traits::input_parameter< const double& >::type prob_ins(prob_insSEXP);
    Rcpp::traits::input_parameter< const double& >::type prob_del(prob_delSEXP);
    Rcpp::traits::input_parameter< const double& >::type prob_subst(prob_substSEXP);
    pacbio_hap_cpp(hap_set_ptr, out_prefix, sep_files, compress, comp_method, n_reads, n_threads, show_progress, read_pool_size, haplotype_probs, prob_dup, scale, sigma, loc, min_read_len, read_probs, read_lens, max_passes, chi2_params_n, chi2_params_s, sqrt_params, norm_params, prob_thresh, prob_ins, prob_del, prob_subst);
    return R_NilValue;
END_RCPP
}
// read_fasta_noind
SEXP read_fasta_noind(const std::vector<std::string>& fasta_files, const bool& cut_names, const bool& remove_soft_mask);
RcppExport SEXP _jackalope_read_fasta_noind(SEXP fasta_filesSEXP, SEXP cut_namesSEXP, SEXP remove_soft_maskSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const std::vector<std::string>& >::type fasta_files(fasta_filesSEXP);
    Rcpp::traits::input_parameter< const bool& >::type cut_names(cut_namesSEXP);
    Rcpp::traits::input_parameter< const bool& >::type remove_soft_mask(remove_soft_maskSEXP);
    rcpp_result_gen = Rcpp::wrap(read_fasta_noind(fasta_files, cut_names, remove_soft_mask));
    return rcpp_result_gen;
END_RCPP
}
// read_fasta_ind
SEXP read_fasta_ind(const std::vector<std::string>& fasta_files, const std::vector<std::string>& fai_files, const bool& remove_soft_mask);
RcppExport SEXP _jackalope_read_fasta_ind(SEXP fasta_filesSEXP, SEXP fai_filesSEXP, SEXP remove_soft_maskSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const std::vector<std::string>& >::type fasta_files(fasta_filesSEXP);
    Rcpp::traits::input_parameter< const std::vector<std::string>& >::type fai_files(fai_filesSEXP);
    Rcpp::traits::input_parameter< const bool& >::type remove_soft_mask(remove_soft_maskSEXP);
    rcpp_result_gen = Rcpp::wrap(read_fasta_ind(fasta_files, fai_files, remove_soft_mask));
    return rcpp_result_gen;
END_RCPP
}
// write_ref_fasta
void write_ref_fasta(const std::string& out_prefix, SEXP ref_genome_ptr, const uint64& text_width, const int& compress, const std::string& comp_method, const bool& show_progress);
RcppExport SEXP _jackalope_write_ref_fasta(SEXP out_prefixSEXP, SEXP ref_genome_ptrSEXP, SEXP text_widthSEXP, SEXP compressSEXP, SEXP comp_methodSEXP, SEXP show_progressSEXP) {
BEGIN_RCPP
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const std::string& >::type out_prefix(out_prefixSEXP);
    Rcpp::traits::input_parameter< SEXP >::type ref_genome_ptr(ref_genome_ptrSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type text_width(text_widthSEXP);
    Rcpp::traits::input_parameter< const int& >::type compress(compressSEXP);
    Rcpp::traits::input_parameter< const std::string& >::type comp_method(comp_methodSEXP);
    Rcpp::traits::input_parameter< const bool& >::type show_progress(show_progressSEXP);
    write_ref_fasta(out_prefix, ref_genome_ptr, text_width, compress, comp_method, show_progress);
    return R_NilValue;
END_RCPP
}
// write_haps_fasta
void write_haps_fasta(std::string out_prefix, SEXP hap_set_ptr, const uint64& text_width, const int& compress, const std::string& comp_method, uint64 n_threads, const bool& show_progress);
RcppExport SEXP _jackalope_write_haps_fasta(SEXP out_prefixSEXP, SEXP hap_set_ptrSEXP, SEXP text_widthSEXP, SEXP compressSEXP, SEXP comp_methodSEXP, SEXP n_threadsSEXP, SEXP show_progressSEXP) {
BEGIN_RCPP
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< std::string >::type out_prefix(out_prefixSEXP);
    Rcpp::traits::input_parameter< SEXP >::type hap_set_ptr(hap_set_ptrSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type text_width(text_widthSEXP);
    Rcpp::traits::input_parameter< const int& >::type compress(compressSEXP);
    Rcpp::traits::input_parameter< const std::string& >::type comp_method(comp_methodSEXP);
    Rcpp::traits::input_parameter< uint64 >::type n_threads(n_threadsSEXP);
    Rcpp::traits::input_parameter< const bool& >::type show_progress(show_progressSEXP);
    write_haps_fasta(out_prefix, hap_set_ptr, text_width, compress, comp_method, n_threads, show_progress);
    return R_NilValue;
END_RCPP
}
// read_ms_trees_
std::vector<std::vector<std::string>> read_ms_trees_(std::string ms_file);
RcppExport SEXP _jackalope_read_ms_trees_(SEXP ms_fileSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< std::string >::type ms_file(ms_fileSEXP);
    rcpp_result_gen = Rcpp::wrap(read_ms_trees_(ms_file));
    return rcpp_result_gen;
END_RCPP
}
// coal_file_sites
arma::field<arma::mat> coal_file_sites(std::string ms_file);
RcppExport SEXP _jackalope_coal_file_sites(SEXP ms_fileSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< std::string >::type ms_file(ms_fileSEXP);
    rcpp_result_gen = Rcpp::wrap(coal_file_sites(ms_file));
    return rcpp_result_gen;
END_RCPP
}
// read_vcf_cpp
SEXP read_vcf_cpp(SEXP reference_ptr, const std::string& fn, const bool& print_names);
RcppExport SEXP _jackalope_read_vcf_cpp(SEXP reference_ptrSEXP, SEXP fnSEXP, SEXP print_namesSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP >::type reference_ptr(reference_ptrSEXP);
    Rcpp::traits::input_parameter< const std::string& >::type fn(fnSEXP);
    Rcpp::traits::input_parameter< const bool& >::type print_names(print_namesSEXP);
    rcpp_result_gen = Rcpp::wrap(read_vcf_cpp(reference_ptr, fn, print_names));
    return rcpp_result_gen;
END_RCPP
}
// write_vcf_cpp
void write_vcf_cpp(std::string out_prefix, const int& compress, SEXP hap_set_ptr, const IntegerMatrix& sample_matrix, const bool& show_progress);
RcppExport SEXP _jackalope_write_vcf_cpp(SEXP out_prefixSEXP, SEXP compressSEXP, SEXP hap_set_ptrSEXP, SEXP sample_matrixSEXP, SEXP show_progressSEXP) {
BEGIN_RCPP
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< std::string >::type out_prefix(out_prefixSEXP);
    Rcpp::traits::input_parameter< const int& >::type compress(compressSEXP);
    Rcpp::traits::input_parameter< SEXP >::type hap_set_ptr(hap_set_ptrSEXP);
    Rcpp::traits::input_parameter< const IntegerMatrix& >::type sample_matrix(sample_matrixSEXP);
    Rcpp::traits::input_parameter< const bool& >::type show_progress(show_progressSEXP);
    write_vcf_cpp(out_prefix, compress, hap_set_ptr, sample_matrix, show_progress);
    return R_NilValue;
END_RCPP
}
// evolve_across_trees
SEXP evolve_across_trees(SEXP& ref_genome_ptr, const List& genome_phylo_info, const std::vector<arma::mat>& Q, const std::vector<arma::mat>& U, const std::vector<arma::mat>& Ui, const std::vector<arma::vec>& L, const double& invariant, const arma::vec& insertion_rates, const arma::vec& deletion_rates, const double& epsilon, const std::vector<double>& pi_tcag, uint64 n_threads, const bool& show_progress);
RcppExport SEXP _jackalope_evolve_across_trees(SEXP ref_genome_ptrSEXP, SEXP genome_phylo_infoSEXP, SEXP QSEXP, SEXP USEXP, SEXP UiSEXP, SEXP LSEXP, SEXP invariantSEXP, SEXP insertion_ratesSEXP, SEXP deletion_ratesSEXP, SEXP epsilonSEXP, SEXP pi_tcagSEXP, SEXP n_threadsSEXP, SEXP show_progressSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP& >::type ref_genome_ptr(ref_genome_ptrSEXP);
    Rcpp::traits::input_parameter< const List& >::type genome_phylo_info(genome_phylo_infoSEXP);
    Rcpp::traits::input_parameter< const std::vector<arma::mat>& >::type Q(QSEXP);
    Rcpp::traits::input_parameter< const std::vector<arma::mat>& >::type U(USEXP);
    Rcpp::traits::input_parameter< const std::vector<arma::mat>& >::type Ui(UiSEXP);
    Rcpp::traits::input_parameter< const std::vector<arma::vec>& >::type L(LSEXP);
    Rcpp::traits::input_parameter< const double& >::type invariant(invariantSEXP);
    Rcpp::traits::input_parameter< const arma::vec& >::type insertion_rates(insertion_ratesSEXP);
    Rcpp::traits::input_parameter< const arma::vec& >::type deletion_rates(deletion_ratesSEXP);
    Rcpp::traits::input_parameter< const double& >::type epsilon(epsilonSEXP);
    Rcpp::traits::input_parameter< const std::vector<double>& >::type pi_tcag(pi_tcagSEXP);
    Rcpp::traits::input_parameter< uint64 >::type n_threads(n_threadsSEXP);
    Rcpp::traits::input_parameter< const bool& >::type show_progress(show_progressSEXP);
    rcpp_result_gen = Rcpp::wrap(evolve_across_trees(ref_genome_ptr, genome_phylo_info, Q, U, Ui, L, invariant, insertion_rates, deletion_rates, epsilon, pi_tcag, n_threads, show_progress));
    return rcpp_result_gen;
END_RCPP
}
// print_ref_genome
void print_ref_genome(SEXP ref_genome_ptr);
RcppExport SEXP _jackalope_print_ref_genome(SEXP ref_genome_ptrSEXP) {
BEGIN_RCPP
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP >::type ref_genome_ptr(ref_genome_ptrSEXP);
    print_ref_genome(ref_genome_ptr);
    return R_NilValue;
END_RCPP
}
// print_hap_set
void print_hap_set(SEXP hap_set_ptr);
RcppExport SEXP _jackalope_print_hap_set(SEXP hap_set_ptrSEXP) {
BEGIN_RCPP
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP >::type hap_set_ptr(hap_set_ptrSEXP);
    print_hap_set(hap_set_ptr);
    return R_NilValue;
END_RCPP
}
// make_ref_genome
SEXP make_ref_genome(const std::vector<std::string>& chroms);
RcppExport SEXP _jackalope_make_ref_genome(SEXP chromsSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const std::vector<std::string>& >::type chroms(chromsSEXP);
    rcpp_result_gen = Rcpp::wrap(make_ref_genome(chroms));
    return rcpp_result_gen;
END_RCPP
}
// make_hap_set
SEXP make_hap_set(SEXP ref_genome_ptr, const uint64& n_haps);
RcppExport SEXP _jackalope_make_hap_set(SEXP ref_genome_ptrSEXP, SEXP n_hapsSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP >::type ref_genome_ptr(ref_genome_ptrSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type n_haps(n_hapsSEXP);
    rcpp_result_gen = Rcpp::wrap(make_hap_set(ref_genome_ptr, n_haps));
    return rcpp_result_gen;
END_RCPP
}
// view_ref_genome_nchroms
IntegerVector view_ref_genome_nchroms(SEXP ref_genome_ptr);
RcppExport SEXP _jackalope_view_ref_genome_nchroms(SEXP ref_genome_ptrSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP >::type ref_genome_ptr(ref_genome_ptrSEXP);
    rcpp_result_gen = Rcpp::wrap(view_ref_genome_nchroms(ref_genome_ptr));
    return rcpp_result_gen;
END_RCPP
}
// view_hap_set_nchroms
IntegerVector view_hap_set_nchroms(SEXP hap_set_ptr);
RcppExport SEXP _jackalope_view_hap_set_nchroms(SEXP hap_set_ptrSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP >::type hap_set_ptr(hap_set_ptrSEXP);
    rcpp_result_gen = Rcpp::wrap(view_hap_set_nchroms(hap_set_ptr));
    return rcpp_result_gen;
END_RCPP
}
// view_hap_set_nhaps
IntegerVector view_hap_set_nhaps(SEXP hap_set_ptr);
RcppExport SEXP _jackalope_view_hap_set_nhaps(SEXP hap_set_ptrSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP >::type hap_set_ptr(hap_set_ptrSEXP);
    rcpp_result_gen = Rcpp::wrap(view_hap_set_nhaps(hap_set_ptr));
    return rcpp_result_gen;
END_RCPP
}
// view_ref_genome_chrom_sizes
IntegerVector view_ref_genome_chrom_sizes(SEXP ref_genome_ptr);
RcppExport SEXP _jackalope_view_ref_genome_chrom_sizes(SEXP ref_genome_ptrSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP >::type ref_genome_ptr(ref_genome_ptrSEXP);
    rcpp_result_gen = Rcpp::wrap(view_ref_genome_chrom_sizes(ref_genome_ptr));
    return rcpp_result_gen;
END_RCPP
}
// view_hap_genome_chrom_sizes
IntegerVector view_hap_genome_chrom_sizes(SEXP hap_set_ptr, const uint64& hap_ind);
RcppExport SEXP _jackalope_view_hap_genome_chrom_sizes(SEXP hap_set_ptrSEXP, SEXP hap_indSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP >::type hap_set_ptr(hap_set_ptrSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type hap_ind(hap_indSEXP);
    rcpp_result_gen = Rcpp::wrap(view_hap_genome_chrom_sizes(hap_set_ptr, hap_ind));
    return rcpp_result_gen;
END_RCPP
}
// view_ref_genome_chrom
std::string view_ref_genome_chrom(SEXP ref_genome_ptr, const uint64& chrom_ind);
RcppExport SEXP _jackalope_view_ref_genome_chrom(SEXP ref_genome_ptrSEXP, SEXP chrom_indSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP >::type ref_genome_ptr(ref_genome_ptrSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type chrom_ind(chrom_indSEXP);
    rcpp_result_gen = Rcpp::wrap(view_ref_genome_chrom(ref_genome_ptr, chrom_ind));
    return rcpp_result_gen;
END_RCPP
}
// view_hap_genome_chrom
std::string view_hap_genome_chrom(SEXP hap_set_ptr, const uint64& hap_ind, const uint64& chrom_ind);
RcppExport SEXP _jackalope_view_hap_genome_chrom(SEXP hap_set_ptrSEXP, SEXP hap_indSEXP, SEXP chrom_indSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP >::type hap_set_ptr(hap_set_ptrSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type hap_ind(hap_indSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type chrom_ind(chrom_indSEXP);
    rcpp_result_gen = Rcpp::wrap(view_hap_genome_chrom(hap_set_ptr, hap_ind, chrom_ind));
    return rcpp_result_gen;
END_RCPP
}
// view_ref_genome
std::vector<std::string> view_ref_genome(SEXP ref_genome_ptr);
RcppExport SEXP _jackalope_view_ref_genome(SEXP ref_genome_ptrSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP >::type ref_genome_ptr(ref_genome_ptrSEXP);
    rcpp_result_gen = Rcpp::wrap(view_ref_genome(ref_genome_ptr));
    return rcpp_result_gen;
END_RCPP
}
// view_hap_genome
std::vector<std::string> view_hap_genome(SEXP hap_set_ptr, const uint64& hap_ind);
RcppExport SEXP _jackalope_view_hap_genome(SEXP hap_set_ptrSEXP, SEXP hap_indSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP >::type hap_set_ptr(hap_set_ptrSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type hap_ind(hap_indSEXP);
    rcpp_result_gen = Rcpp::wrap(view_hap_genome(hap_set_ptr, hap_ind));
    return rcpp_result_gen;
END_RCPP
}
// view_ref_genome_chrom_names
std::vector<std::string> view_ref_genome_chrom_names(SEXP ref_genome_ptr);
RcppExport SEXP _jackalope_view_ref_genome_chrom_names(SEXP ref_genome_ptrSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP >::type ref_genome_ptr(ref_genome_ptrSEXP);
    rcpp_result_gen = Rcpp::wrap(view_ref_genome_chrom_names(ref_genome_ptr));
    return rcpp_result_gen;
END_RCPP
}
// view_hap_set_hap_names
std::vector<std::string> view_hap_set_hap_names(SEXP hap_set_ptr);
RcppExport SEXP _jackalope_view_hap_set_hap_names(SEXP hap_set_ptrSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP >::type hap_set_ptr(hap_set_ptrSEXP);
    rcpp_result_gen = Rcpp::wrap(view_hap_set_hap_names(hap_set_ptr));
    return rcpp_result_gen;
END_RCPP
}
// view_ref_genome_gc_content
double view_ref_genome_gc_content(SEXP ref_genome_ptr, const uint64& chrom_ind, const uint64& start, const uint64& end);
RcppExport SEXP _jackalope_view_ref_genome_gc_content(SEXP ref_genome_ptrSEXP, SEXP chrom_indSEXP, SEXP startSEXP, SEXP endSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP >::type ref_genome_ptr(ref_genome_ptrSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type chrom_ind(chrom_indSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type start(startSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type end(endSEXP);
    rcpp_result_gen = Rcpp::wrap(view_ref_genome_gc_content(ref_genome_ptr, chrom_ind, start, end));
    return rcpp_result_gen;
END_RCPP
}
// view_hap_set_gc_content
double view_hap_set_gc_content(SEXP hap_set_ptr, const uint64& chrom_ind, const uint64& hap_ind, const uint64& start, const uint64& end);
RcppExport SEXP _jackalope_view_hap_set_gc_content(SEXP hap_set_ptrSEXP, SEXP chrom_indSEXP, SEXP hap_indSEXP, SEXP startSEXP, SEXP endSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP >::type hap_set_ptr(hap_set_ptrSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type chrom_ind(chrom_indSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type hap_ind(hap_indSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type start(startSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type end(endSEXP);
    rcpp_result_gen = Rcpp::wrap(view_hap_set_gc_content(hap_set_ptr, chrom_ind, hap_ind, start, end));
    return rcpp_result_gen;
END_RCPP
}
// view_ref_genome_nt_content
double view_ref_genome_nt_content(SEXP ref_genome_ptr, const char& nt, const uint64& chrom_ind, const uint64& start, const uint64& end);
RcppExport SEXP _jackalope_view_ref_genome_nt_content(SEXP ref_genome_ptrSEXP, SEXP ntSEXP, SEXP chrom_indSEXP, SEXP startSEXP, SEXP endSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP >::type ref_genome_ptr(ref_genome_ptrSEXP);
    Rcpp::traits::input_parameter< const char& >::type nt(ntSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type chrom_ind(chrom_indSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type start(startSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type end(endSEXP);
    rcpp_result_gen = Rcpp::wrap(view_ref_genome_nt_content(ref_genome_ptr, nt, chrom_ind, start, end));
    return rcpp_result_gen;
END_RCPP
}
// view_hap_set_nt_content
double view_hap_set_nt_content(SEXP hap_set_ptr, const char& nt, const uint64& chrom_ind, const uint64& hap_ind, const uint64& start, const uint64& end);
RcppExport SEXP _jackalope_view_hap_set_nt_content(SEXP hap_set_ptrSEXP, SEXP ntSEXP, SEXP chrom_indSEXP, SEXP hap_indSEXP, SEXP startSEXP, SEXP endSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP >::type hap_set_ptr(hap_set_ptrSEXP);
    Rcpp::traits::input_parameter< const char& >::type nt(ntSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type chrom_ind(chrom_indSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type hap_ind(hap_indSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type start(startSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type end(endSEXP);
    rcpp_result_gen = Rcpp::wrap(view_hap_set_nt_content(hap_set_ptr, nt, chrom_ind, hap_ind, start, end));
    return rcpp_result_gen;
END_RCPP
}
// set_ref_genome_chrom_names
void set_ref_genome_chrom_names(SEXP ref_genome_ptr, const std::vector<uint64>& chrom_inds, const std::vector<std::string>& names);
RcppExport SEXP _jackalope_set_ref_genome_chrom_names(SEXP ref_genome_ptrSEXP, SEXP chrom_indsSEXP, SEXP namesSEXP) {
BEGIN_RCPP
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP >::type ref_genome_ptr(ref_genome_ptrSEXP);
    Rcpp::traits::input_parameter< const std::vector<uint64>& >::type chrom_inds(chrom_indsSEXP);
    Rcpp::traits::input_parameter< const std::vector<std::string>& >::type names(namesSEXP);
    set_ref_genome_chrom_names(ref_genome_ptr, chrom_inds, names);
    return R_NilValue;
END_RCPP
}
// clean_ref_genome_chrom_names
void clean_ref_genome_chrom_names(SEXP ref_genome_ptr);
RcppExport SEXP _jackalope_clean_ref_genome_chrom_names(SEXP ref_genome_ptrSEXP) {
BEGIN_RCPP
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP >::type ref_genome_ptr(ref_genome_ptrSEXP);
    clean_ref_genome_chrom_names(ref_genome_ptr);
    return R_NilValue;
END_RCPP
}
// set_hap_set_hap_names
void set_hap_set_hap_names(SEXP hap_set_ptr, const std::vector<uint64>& hap_inds, const std::vector<std::string>& names);
RcppExport SEXP _jackalope_set_hap_set_hap_names(SEXP hap_set_ptrSEXP, SEXP hap_indsSEXP, SEXP namesSEXP) {
BEGIN_RCPP
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP >::type hap_set_ptr(hap_set_ptrSEXP);
    Rcpp::traits::input_parameter< const std::vector<uint64>& >::type hap_inds(hap_indsSEXP);
    Rcpp::traits::input_parameter< const std::vector<std::string>& >::type names(namesSEXP);
    set_hap_set_hap_names(hap_set_ptr, hap_inds, names);
    return R_NilValue;
END_RCPP
}
// remove_ref_genome_chroms
void remove_ref_genome_chroms(SEXP ref_genome_ptr, std::vector<uint64> chrom_inds);
RcppExport SEXP _jackalope_remove_ref_genome_chroms(SEXP ref_genome_ptrSEXP, SEXP chrom_indsSEXP) {
BEGIN_RCPP
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP >::type ref_genome_ptr(ref_genome_ptrSEXP);
    Rcpp::traits::input_parameter< std::vector<uint64> >::type chrom_inds(chrom_indsSEXP);
    remove_ref_genome_chroms(ref_genome_ptr, chrom_inds);
    return R_NilValue;
END_RCPP
}
// remove_hap_set_haps
void remove_hap_set_haps(SEXP hap_set_ptr, std::vector<uint64> hap_inds);
RcppExport SEXP _jackalope_remove_hap_set_haps(SEXP hap_set_ptrSEXP, SEXP hap_indsSEXP) {
BEGIN_RCPP
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP >::type hap_set_ptr(hap_set_ptrSEXP);
    Rcpp::traits::input_parameter< std::vector<uint64> >::type hap_inds(hap_indsSEXP);
    remove_hap_set_haps(hap_set_ptr, hap_inds);
    return R_NilValue;
END_RCPP
}
// add_ref_genome_chroms
void add_ref_genome_chroms(SEXP ref_genome_ptr, const std::vector<std::string>& new_chroms, const std::vector<std::string>& new_names);
RcppExport SEXP _jackalope_add_ref_genome_chroms(SEXP ref_genome_ptrSEXP, SEXP new_chromsSEXP, SEXP new_namesSEXP) {
BEGIN_RCPP
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP >::type ref_genome_ptr(ref_genome_ptrSEXP);
    Rcpp::traits::input_parameter< const std::vector<std::string>& >::type new_chroms(new_chromsSEXP);
    Rcpp::traits::input_parameter< const std::vector<std::string>& >::type new_names(new_namesSEXP);
    add_ref_genome_chroms(ref_genome_ptr, new_chroms, new_names);
    return R_NilValue;
END_RCPP
}
// add_hap_set_haps
void add_hap_set_haps(SEXP hap_set_ptr, const std::vector<std::string>& new_names);
RcppExport SEXP _jackalope_add_hap_set_haps(SEXP hap_set_ptrSEXP, SEXP new_namesSEXP) {
BEGIN_RCPP
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP >::type hap_set_ptr(hap_set_ptrSEXP);
    Rcpp::traits::input_parameter< const std::vector<std::string>& >::type new_names(new_namesSEXP);
    add_hap_set_haps(hap_set_ptr, new_names);
    return R_NilValue;
END_RCPP
}
// dup_hap_set_haps
void dup_hap_set_haps(SEXP hap_set_ptr, const std::vector<uint64>& hap_inds, const std::vector<std::string>& new_names);
RcppExport SEXP _jackalope_dup_hap_set_haps(SEXP hap_set_ptrSEXP, SEXP hap_indsSEXP, SEXP new_namesSEXP) {
BEGIN_RCPP
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP >::type hap_set_ptr(hap_set_ptrSEXP);
    Rcpp::traits::input_parameter< const std::vector<uint64>& >::type hap_inds(hap_indsSEXP);
    Rcpp::traits::input_parameter< const std::vector<std::string>& >::type new_names(new_namesSEXP);
    dup_hap_set_haps(hap_set_ptr, hap_inds, new_names);
    return R_NilValue;
END_RCPP
}
// view_mutations
DataFrame view_mutations(SEXP hap_set_ptr, const uint64& hap_ind);
RcppExport SEXP _jackalope_view_mutations(SEXP hap_set_ptrSEXP, SEXP hap_indSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP >::type hap_set_ptr(hap_set_ptrSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type hap_ind(hap_indSEXP);
    rcpp_result_gen = Rcpp::wrap(view_mutations(hap_set_ptr, hap_ind));
    return rcpp_result_gen;
END_RCPP
}
// examine_mutations
List examine_mutations(SEXP hap_set_ptr, const uint64& hap_ind, const uint64& chrom_ind);
RcppExport SEXP _jackalope_examine_mutations(SEXP hap_set_ptrSEXP, SEXP hap_indSEXP, SEXP chrom_indSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP >::type hap_set_ptr(hap_set_ptrSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type hap_ind(hap_indSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type chrom_ind(chrom_indSEXP);
    rcpp_result_gen = Rcpp::wrap(examine_mutations(hap_set_ptr, hap_ind, chrom_ind));
    return rcpp_result_gen;
END_RCPP
}
// add_substitution
void add_substitution(SEXP hap_set_ptr, const uint64& hap_ind, const uint64& chrom_ind, const char& nucleo_, const uint64& new_pos_);
RcppExport SEXP _jackalope_add_substitution(SEXP hap_set_ptrSEXP, SEXP hap_indSEXP, SEXP chrom_indSEXP, SEXP nucleo_SEXP, SEXP new_pos_SEXP) {
BEGIN_RCPP
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP >::type hap_set_ptr(hap_set_ptrSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type hap_ind(hap_indSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type chrom_ind(chrom_indSEXP);
    Rcpp::traits::input_parameter< const char& >::type nucleo_(nucleo_SEXP);
    Rcpp::traits::input_parameter< const uint64& >::type new_pos_(new_pos_SEXP);
    add_substitution(hap_set_ptr, hap_ind, chrom_ind, nucleo_, new_pos_);
    return R_NilValue;
END_RCPP
}
// add_insertion
void add_insertion(SEXP hap_set_ptr, const uint64& hap_ind, const uint64& chrom_ind, const std::string& nucleos_, const uint64& new_pos_);
RcppExport SEXP _jackalope_add_insertion(SEXP hap_set_ptrSEXP, SEXP hap_indSEXP, SEXP chrom_indSEXP, SEXP nucleos_SEXP, SEXP new_pos_SEXP) {
BEGIN_RCPP
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP >::type hap_set_ptr(hap_set_ptrSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type hap_ind(hap_indSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type chrom_ind(chrom_indSEXP);
    Rcpp::traits::input_parameter< const std::string& >::type nucleos_(nucleos_SEXP);
    Rcpp::traits::input_parameter< const uint64& >::type new_pos_(new_pos_SEXP);
    add_insertion(hap_set_ptr, hap_ind, chrom_ind, nucleos_, new_pos_);
    return R_NilValue;
END_RCPP
}
// add_deletion
void add_deletion(SEXP hap_set_ptr, const uint64& hap_ind, const uint64& chrom_ind, const uint64& size_, const uint64& new_pos_);
RcppExport SEXP _jackalope_add_deletion(SEXP hap_set_ptrSEXP, SEXP hap_indSEXP, SEXP chrom_indSEXP, SEXP size_SEXP, SEXP new_pos_SEXP) {
BEGIN_RCPP
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP >::type hap_set_ptr(hap_set_ptrSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type hap_ind(hap_indSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type chrom_ind(chrom_indSEXP);
    Rcpp::traits::input_parameter< const uint64& >::type size_(size_SEXP);
    Rcpp::traits::input_parameter< const uint64& >::type new_pos_(new_pos_SEXP);
    add_deletion(hap_set_ptr, hap_ind, chrom_ind, size_, new_pos_);
    return R_NilValue;
END_RCPP
}
// sub_TN93_cpp
List sub_TN93_cpp(const double& mu, std::vector<double> pi_tcag, const double& alpha_1, const double& alpha_2, const double& beta, const double& gamma_shape, const uint32& gamma_k, const double& invariant);
RcppExport SEXP _jackalope_sub_TN93_cpp(SEXP muSEXP, SEXP pi_tcagSEXP, SEXP alpha_1SEXP, SEXP alpha_2SEXP, SEXP betaSEXP, SEXP gamma_shapeSEXP, SEXP gamma_kSEXP, SEXP invariantSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const double& >::type mu(muSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type pi_tcag(pi_tcagSEXP);
    Rcpp::traits::input_parameter< const double& >::type alpha_1(alpha_1SEXP);
    Rcpp::traits::input_parameter< const double& >::type alpha_2(alpha_2SEXP);
    Rcpp::traits::input_parameter< const double& >::type beta(betaSEXP);
    Rcpp::traits::input_parameter< const double& >::type gamma_shape(gamma_shapeSEXP);
    Rcpp::traits::input_parameter< const uint32& >::type gamma_k(gamma_kSEXP);
    Rcpp::traits::input_parameter< const double& >::type invariant(invariantSEXP);
    rcpp_result_gen = Rcpp::wrap(sub_TN93_cpp(mu, pi_tcag, alpha_1, alpha_2, beta, gamma_shape, gamma_k, invariant));
    return rcpp_result_gen;
END_RCPP
}
// sub_GTR_cpp
List sub_GTR_cpp(const double& mu, std::vector<double> pi_tcag, const std::vector<double>& abcdef, const double& gamma_shape, const uint32& gamma_k, const double& invariant);
RcppExport SEXP _jackalope_sub_GTR_cpp(SEXP muSEXP, SEXP pi_tcagSEXP, SEXP abcdefSEXP, SEXP gamma_shapeSEXP, SEXP gamma_kSEXP, SEXP invariantSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const double& >::type mu(muSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type pi_tcag(pi_tcagSEXP);
    Rcpp::traits::input_parameter< const std::vector<double>& >::type abcdef(abcdefSEXP);
    Rcpp::traits::input_parameter< const double& >::type gamma_shape(gamma_shapeSEXP);
    Rcpp::traits::input_parameter< const uint32& >::type gamma_k(gamma_kSEXP);
    Rcpp::traits::input_parameter< const double& >::type invariant(invariantSEXP);
    rcpp_result_gen = Rcpp::wrap(sub_GTR_cpp(mu, pi_tcag, abcdef, gamma_shape, gamma_k, invariant));
    return rcpp_result_gen;
END_RCPP
}
// sub_UNREST_cpp
List sub_UNREST_cpp(const double& mu, arma::mat Q, const double& gamma_shape, const uint32& gamma_k, const double& invariant);
RcppExport SEXP _jackalope_sub_UNREST_cpp(SEXP muSEXP, SEXP QSEXP, SEXP gamma_shapeSEXP, SEXP gamma_kSEXP, SEXP invariantSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const double& >::type mu(muSEXP);
    Rcpp::traits::input_parameter< arma::mat >::type Q(QSEXP);
    Rcpp::traits::input_parameter< const double& >::type gamma_shape(gamma_shapeSEXP);
    Rcpp::traits::input_parameter< const uint32& >::type gamma_k(gamma_kSEXP);
    Rcpp::traits::input_parameter< const double& >::type invariant(invariantSEXP);
    rcpp_result_gen = Rcpp::wrap(sub_UNREST_cpp(mu, Q, gamma_shape, gamma_k, invariant));
    return rcpp_result_gen;
END_RCPP
}
// using_openmp
bool using_openmp();
RcppExport SEXP _jackalope_using_openmp() {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    rcpp_result_gen = Rcpp::wrap(using_openmp());
    return rcpp_result_gen;
END_RCPP
}

static const R_CallMethodDef CallEntries[] = {
    {"_jackalope_merge_all_chromosomes_cpp", (DL_FUNC) &_jackalope_merge_all_chromosomes_cpp, 1},
    {"_jackalope_merge_chromosomes_cpp", (DL_FUNC) &_jackalope_merge_chromosomes_cpp, 2},
    {"_jackalope_filter_chromosomes_cpp", (DL_FUNC) &_jackalope_filter_chromosomes_cpp, 3},
    {"_jackalope_replace_Ns_cpp", (DL_FUNC) &_jackalope_replace_Ns_cpp, 4},
    {"_jackalope_create_genome_cpp", (DL_FUNC) &_jackalope_create_genome_cpp, 5},
    {"_jackalope_rando_chroms", (DL_FUNC) &_jackalope_rando_chroms, 5},
    {"_jackalope_add_ssites_cpp", (DL_FUNC) &_jackalope_add_ssites_cpp, 8},
    {"_jackalope_illumina_ref_cpp", (DL_FUNC) &_jackalope_illumina_ref_cpp, 24},
    {"_jackalope_illumina_hap_cpp", (DL_FUNC) &_jackalope_illumina_hap_cpp, 26},
    {"_jackalope_pacbio_ref_cpp", (DL_FUNC) &_jackalope_pacbio_ref_cpp, 24},
    {"_jackalope_pacbio_hap_cpp", (DL_FUNC) &_jackalope_pacbio_hap_cpp, 26},
    {"_jackalope_read_fasta_noind", (DL_FUNC) &_jackalope_read_fasta_noind, 3},
    {"_jackalope_read_fasta_ind", (DL_FUNC) &_jackalope_read_fasta_ind, 3},
    {"_jackalope_write_ref_fasta", (DL_FUNC) &_jackalope_write_ref_fasta, 6},
    {"_jackalope_write_haps_fasta", (DL_FUNC) &_jackalope_write_haps_fasta, 7},
    {"_jackalope_read_ms_trees_", (DL_FUNC) &_jackalope_read_ms_trees_, 1},
    {"_jackalope_coal_file_sites", (DL_FUNC) &_jackalope_coal_file_sites, 1},
    {"_jackalope_read_vcf_cpp", (DL_FUNC) &_jackalope_read_vcf_cpp, 3},
    {"_jackalope_write_vcf_cpp", (DL_FUNC) &_jackalope_write_vcf_cpp, 5},
    {"_jackalope_evolve_across_trees", (DL_FUNC) &_jackalope_evolve_across_trees, 13},
    {"_jackalope_print_ref_genome", (DL_FUNC) &_jackalope_print_ref_genome, 1},
    {"_jackalope_print_hap_set", (DL_FUNC) &_jackalope_print_hap_set, 1},
    {"_jackalope_make_ref_genome", (DL_FUNC) &_jackalope_make_ref_genome, 1},
    {"_jackalope_make_hap_set", (DL_FUNC) &_jackalope_make_hap_set, 2},
    {"_jackalope_view_ref_genome_nchroms", (DL_FUNC) &_jackalope_view_ref_genome_nchroms, 1},
    {"_jackalope_view_hap_set_nchroms", (DL_FUNC) &_jackalope_view_hap_set_nchroms, 1},
    {"_jackalope_view_hap_set_nhaps", (DL_FUNC) &_jackalope_view_hap_set_nhaps, 1},
    {"_jackalope_view_ref_genome_chrom_sizes", (DL_FUNC) &_jackalope_view_ref_genome_chrom_sizes, 1},
    {"_jackalope_view_hap_genome_chrom_sizes", (DL_FUNC) &_jackalope_view_hap_genome_chrom_sizes, 2},
    {"_jackalope_view_ref_genome_chrom", (DL_FUNC) &_jackalope_view_ref_genome_chrom, 2},
    {"_jackalope_view_hap_genome_chrom", (DL_FUNC) &_jackalope_view_hap_genome_chrom, 3},
    {"_jackalope_view_ref_genome", (DL_FUNC) &_jackalope_view_ref_genome, 1},
    {"_jackalope_view_hap_genome", (DL_FUNC) &_jackalope_view_hap_genome, 2},
    {"_jackalope_view_ref_genome_chrom_names", (DL_FUNC) &_jackalope_view_ref_genome_chrom_names, 1},
    {"_jackalope_view_hap_set_hap_names", (DL_FUNC) &_jackalope_view_hap_set_hap_names, 1},
    {"_jackalope_view_ref_genome_gc_content", (DL_FUNC) &_jackalope_view_ref_genome_gc_content, 4},
    {"_jackalope_view_hap_set_gc_content", (DL_FUNC) &_jackalope_view_hap_set_gc_content, 5},
    {"_jackalope_view_ref_genome_nt_content", (DL_FUNC) &_jackalope_view_ref_genome_nt_content, 5},
    {"_jackalope_view_hap_set_nt_content", (DL_FUNC) &_jackalope_view_hap_set_nt_content, 6},
    {"_jackalope_set_ref_genome_chrom_names", (DL_FUNC) &_jackalope_set_ref_genome_chrom_names, 3},
    {"_jackalope_clean_ref_genome_chrom_names", (DL_FUNC) &_jackalope_clean_ref_genome_chrom_names, 1},
    {"_jackalope_set_hap_set_hap_names", (DL_FUNC) &_jackalope_set_hap_set_hap_names, 3},
    {"_jackalope_remove_ref_genome_chroms", (DL_FUNC) &_jackalope_remove_ref_genome_chroms, 2},
    {"_jackalope_remove_hap_set_haps", (DL_FUNC) &_jackalope_remove_hap_set_haps, 2},
    {"_jackalope_add_ref_genome_chroms", (DL_FUNC) &_jackalope_add_ref_genome_chroms, 3},
    {"_jackalope_add_hap_set_haps", (DL_FUNC) &_jackalope_add_hap_set_haps, 2},
    {"_jackalope_dup_hap_set_haps", (DL_FUNC) &_jackalope_dup_hap_set_haps, 3},
    {"_jackalope_view_mutations", (DL_FUNC) &_jackalope_view_mutations, 2},
    {"_jackalope_examine_mutations", (DL_FUNC) &_jackalope_examine_mutations, 3},
    {"_jackalope_add_substitution", (DL_FUNC) &_jackalope_add_substitution, 5},
    {"_jackalope_add_insertion", (DL_FUNC) &_jackalope_add_insertion, 5},
    {"_jackalope_add_deletion", (DL_FUNC) &_jackalope_add_deletion, 5},
    {"_jackalope_sub_TN93_cpp", (DL_FUNC) &_jackalope_sub_TN93_cpp, 8},
    {"_jackalope_sub_GTR_cpp", (DL_FUNC) &_jackalope_sub_GTR_cpp, 6},
    {"_jackalope_sub_UNREST_cpp", (DL_FUNC) &_jackalope_sub_UNREST_cpp, 5},
    {"_jackalope_using_openmp", (DL_FUNC) &_jackalope_using_openmp, 0},
    {NULL, NULL, 0}
};

RcppExport void R_init_jackalope(DllInfo *dll) {
    R_registerRoutines(dll, NULL, CallEntries, NULL, NULL);
    R_useDynamicSymbols(dll, FALSE);
}
