% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jabr_area.R
\name{jabr_area}
\alias{jabr_area}
\title{Get administrative area}
\usage{
jabr_area(level, code_bps)
}
\arguments{
\item{level}{Level of administrative division. Valid values are "district" for Kota/Kabupaten, "subdistrict" for Kecamatan and "village" for Desa/Kelurahan.}

\item{code_bps}{BPS code of the upper administrative division. Note that BPS code for "district" level is "32". To get "subdistrict" level area, you have to supply the BPS code of the district (Kota/Kabupaten). To get "village" level area, you have to supply the BPS code of the subdistrict (Kecamatan).}
}
\value{
A tibble.
}
\description{
List the administrative area in Jawa Barat.
}
\examples{
\donttest{
library(jabr)

jabr_area(level = "district", code_bps = "32")

# fetch subdistrict area in Kab. Cirebon
jabr_area(level = "subdistrict", code_bps = "3209")
}

}
