context("Rcpp output parsing")

test_that("parseMsPositions works", {
  positions <- rep(0, 10)
  positions <- parseMsPositions("positions: 0.0010 0.0474 0.3171")
  expect_equal(positions[1], 0.001)
  expect_equal(positions[2], 0.0474)
  expect_equal(positions[3], 0.3171)
  expect_equal(length(positions), 3)
  expect_equal(length(parseMsPositions("positions: 0.1 0.2 0.3 0.4 0.5")), 5)
  expect_equal(length(parseMsPositions("positions: 0.1")), 1)
  expect_error(parseMsPositions("0.1 0.2 0.3"))
  expect_error(parseMsPositions(" "))
  expect_error(parseMsPositions("segsites: 0"))
})

test_that("test.parseOutput.ms works", {
  set.seed(25)
  dm.tt@sum.stats <- data.frame()
  dm.tt <- dm.addSummaryStatistic(dm.tt, "file")
  dm.tt <- dm.addSummaryStatistic(dm.tt, "seg.sites")
  ss <- dm.getSampleSize(dm.tt)
  ln <- dm.getLociNumber(dm.tt)
  breaks <- c(0.25, 0.5, 0.75)
  ms.file <- dm.simSumStats(dm.tt, c(1, 5))$file
  expect_error(parseOutput("bulb.txt", ss, ln))
  sum.stats <- parseOutput(ms.file, ss, ln, 0, FALSE, TRUE, FALSE)
  expect_equal(length(sum.stats), 1)
  expect_true(is.list(sum.stats$seg.sites))
  expect_equal(length(sum.stats$seg.sites), dm.getLociNumber(dm.tt))
  sum.stats <- parseOutput(ms.file, ss, ln, 0, TRUE, TRUE, FALSE)
  expect_equal(length(sum.stats), 2)
  expect_true(is.list(sum.stats$seg.sites))
  expect_true(is.matrix(sum.stats$jsfs))
  expect_true(sum(sum.stats$jsfs) > 0)
  expect_error(parseOutput(ms.file, ss, ln, 0, TRUE, TRUE, TRUE))
  sum.stats <- parseOutput(ms.file, ss, ln, 0, TRUE, TRUE, TRUE, breaks, breaks)
  expect_equal(length(sum.stats), 3)
  expect_true(is.list(sum.stats$seg.sites))
  expect_true(is.matrix(sum.stats$jsfs))
  expect_true(sum(sum.stats$jsfs) > 0)
  expect_true(is.matrix(sum.stats$fpc))
  expect_equal(dim(sum.stats$fpc), c(5, 5))
  expect_true(sum(sum.stats$fpc) > 0)
  sum.stats <- parseOutput(ms.file, ss, ln, 0, FALSE, FALSE, 
                           TRUE, c(breaks, 0.9), breaks)
  expect_equal(length(sum.stats), 1)
  expect_true(is.matrix(sum.stats$fpc))
  expect_equal(dim(sum.stats$fpc), c(6, 5))
  expect_true(sum(sum.stats$fpc) > 0)
  sum.stats <- parseOutput(ms.file, ss, ln, 0, FALSE, FALSE, FALSE)
  expect_equal(length(sum.stats), 0)
  sum.stats <- parseOutput(ms.file, ss, ln, 0, generate_polym_classes = TRUE)
  expect_equal(length(sum.stats), 2)
  expect_equal(names(sum.stats$polym_classes), c('private', 'fixed', 'shared'))
  expect_equal(sum(sum.stats$jsfs), sum(sum.stats$polym_classes))
})