% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sweights.R
\name{tsls}
\alias{tsls}
\title{TSLS weights, with controls}
\usage{
tsls(X, Z, Z0, Z1, components, treat, order = NULL)
}
\arguments{
\item{X}{Matrix of covariates, including the treatment indicator.}

\item{Z}{Matrix of instruments.}

\item{Z0}{Matrix of instruments, fixing treatment to 0.}

\item{Z1}{Matrix of instruments, fixing treatment to 1.}

\item{components}{Vector of variable names of which user wants the
S-weights for.}

\item{treat}{Variable name for the treatment indicator.}

\item{order}{integer, default set to \code{NULL}. This is simply an
index of which IV-like specification the estimate corresponds
to.}
}
\value{
A list of two vectors: one is the weight for D = 0, the
    other is the weight for D = 1.
}
\description{
Function generating the S-weights for TSLS estimand, with controls.
}
