% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{getRange}
\alias{getRange}
\title{Function for rounding and/or segmenting a range.}
\usage{
getRange(x, dec = NULL, step = NULL, n.seg = 2)
}
\arguments{
\item{x}{A numeric vector.}

\item{dec}{Number of decimal points for rounding using function 
\code{\link[base]{round}}. Applied after argument 
\code{step}. If NULL (default), no rounding is applied.}

\item{step}{Round the}

\item{n.seg}{Numeric value, number of values in the equally spaced sequence. 
Default is 2 (min, max).}
}
\value{
vector, range of equally spaced sequence.
}
\description{
Function for rounding and/or segmenting a range.
}
\examples{
zlim <- c(-2.5, 3.01)
# does not change anything:
getRange(zlim)
# create a range of 5 numbers: 
# (basically just using seq )
getRange(zlim, n.seg=5)
# rounds the numbers:
getRange(zlim, dec=0)
getRange(zlim, n.seg=5, dec=0)
# extreme values are multiplications of 5
# that contains zlim values:
getRange(zlim, step=5)
getRange(zlim, step=5, n.seg=5)
# similar, but not the same:
getRange(zlim, n.seg=5, dec=0)
getRange(zlim, n.seg=5, step=1)
# combining:
getRange(zlim, n.seg=5, step=1, dec=0)

}
\author{
Jacolien van Rij
}
\seealso{
Other Utility functions: \code{\link{convertNonAlphanumeric}},
  \code{\link{diff_terms}}, \code{\link{findAbsMin}},
  \code{\link{find_difference}},
  \code{\link{find_n_neighbors}}, \code{\link{getDec}},
  \code{\link{group_sort}}, \code{\link{list2str}},
  \code{\link{missing_est}}, \code{\link{move_n_point}},
  \code{\link{print_summary}}, \code{\link{se}},
  \code{\link{summary_data}}, \code{\link{timeBins}}
}

