% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iterator.R
\docType{package}
\name{iterpc}
\alias{iterpc}
\alias{iterpc-package}
\title{Iterator for Permutations and Combinations}
\usage{
iterpc(n, r = NULL, labels = NULL, ordered = FALSE, replace = FALSE)
}
\arguments{
\item{n}{the length of the input sequence or a vector of frequencies for a multiset.}

\item{r}{the length of the output sequence. If missing, equals to \code{sum(n)}.}

\item{labels}{if \code{missing}, natural numbers are used unless \code{n} is a table object.
In that case, the names of \code{n} are used.}

\item{ordered}{\code{TRUE} corresponses to permutation and \code{FALSE} corresponses to combinations.}

\item{replace}{with/without replacement. Default is \code{FALSE}.}
}
\value{
a permutation/combination iterator
}
\description{
Initialize a iterator for permutations or combinations
}
\examples{
#1) all combinations of drawing 2 items from {1, 2, 3}
I <- iterpc(5, 2)
getall(I)

#2) continuing 1), get combination by combination
I <- iterpc(5, 2)
getnext(I) # return 1,2
getnext(I) # return 1,3
getnext(I, 2) # return next 2 results

#3) 3) all permutations of {1, 2, 3} and use of labels
I <- iterpc(3, labels=c("a", "b", "c"), ordered=TRUE)
getall(I)

#4) permutations of multiset and
I <- iterpc(c(2, 1, 1), labels=c("a", "b", "c"), ordered=TRUE)
getall(I)

#5) combinations with replacement and the use of table as input
x <- c("a","a","b","c")
I <- iterpc(table(x), 3, replace=TRUE)
getall(I)
}

