% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fm_xire.R
\name{fm_xire}
\alias{fm_xire}
\title{A Minimum Discrepancy Approach with Fourier Transform in 
Sufficient Dimension Reduction}
\usage{
fm_xire(Y, X, d, m = 30, method = c("FT-IRE"))
}
\arguments{
\item{Y}{Response Vector with dimension n-by-q}

\item{X}{Predictor matrix with dimension n-by-p}

\item{d}{Dimension of SDR}

\item{m}{Number of omega values used to estimate the SDR subspace}

\item{method}{Specify the method of dimension reduction. Default is ``FT-IRE''. Other possible choices are ``FT-DIRE'',``FT-SIRE'',``FT-RIFE'', and ``FT-DRIRE''.}
}
\value{
The function output is a p-by-d matrix. 
\item{hbeta_xire}{An estimator for the SDR subspace.}
}
\description{
\emph{fm_xire()} provides optimal estimators by optimizing a discrepancy 
function using a Fourier transform approach.
}
\examples{
\dontrun{
library(itdr)
data(prostate)
Y = as.matrix(Prostate[,9])
X = as.matrix(Prostate[,-9])
fit.ftire=fm_xire(Y,X,d=1,method="FT-DRIRE")  
fit.ftire$hbeta_xire
}
}
\references{
Weng, J., & Yin, X. (2022). A minimum discrepancy approach with fourier 
transform in sufficient dimension reduction. Stat. Sin., 32.
}
