% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{genotype}
\alias{genotype}
\title{Codify Specimens' Genotypes.}
\usage{
genotype(pop, phase = FALSE)
}
\arguments{
\item{pop}{a list with instances of the R6 class Specimen.}

\item{phase}{logical should the codes keep the phase.}
}
\value{
A numeric or character matrix with the codified Specimens' genotypes.
}
\description{
Codify Specimens' genotypes instances as numeric codes [-1/0/1]
    or as character vector that keeps the phase information.
}
\examples{
data(ToyMap)
spc <- set_specie(ToyMap)

Aa <- founder(spc, "Aa")
aA <- spc$founder("aA")

Both <- list(Aa = Aa, aA = aA)

## different ways
genotype(Both)               # as numeric   
genotype(Both, phase = TRUE) # as character

}
