% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui_plotting-topology.R
\name{ggtopo.topology}
\alias{ggtopo.topology}
\title{Plot a topology}
\usage{
\method{ggtopo}{topology}(x, layout = "auto", edge = "fan", ...)
}
\arguments{
\item{x}{A topology matrix.}

\item{layout}{Optional, layout to use (e.g. "sugiyama", "kk", "stress")}

\item{edge}{"curve" (the default), "line" or "fan".}

\item{...}{Not used for now.}
}
\value{
A ggplot2 plot.
}
\description{
A quick plot using ggraph
}
\examples{
if (requireNamespace("ggraph")) {
  z <- topo(aquarium_mod)
  ggtopo(z)
  ggtopo(z, edge = "line")

  z <- topo(trini_mod)
  ggtopo(z)

  # For finer control, one can build a tbl_graph from the topology and
  # use ggraph directly
  x <- as_tbl_graph(z)
  library(ggraph)
  ggraph(x) + geom_edge_link()
}

}
