% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{epsilon}
\alias{epsilon}
\title{Isotope fractionation value}
\usage{
epsilon(alpha)
}
\arguments{
\item{alpha}{Isotope fractionation factor}
}
\value{
Returns the isotope fractionation value (‰).
}
\description{
\code{epsilon()} converts isotope fractionation factors to isotope fractionation values.
}
\details{
\deqn{\epsilon^{i}E_{A/B} = \alpha^{i}E_{A/B} - 1}
}
\examples{
epsilon(a18_H2O_OH(25, "Z20-X3LYP"))

}
\seealso{
a_A_B() calculates the isotope fractionation factor between A and B.
}
