% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CumSumSuite.R
\name{cumsumAtSamplingLocation}
\alias{cumsumAtSamplingLocation}
\alias{cumsum_at_point}
\title{Cumulative sum at coordinates}
\usage{
cumsumAtSamplingLocation(indivraster, Lat, Lon)
}
\arguments{
\item{indivraster}{RasterLayer representing normalized probability of origin surface}

\item{Lat}{Integer latitude}

\item{Lon}{Integer longitude}
}
\description{
Function estimates cumulative sum of all values in a surface below the value at a specified longitude and latitude.
}
\examples{
# Generate example probability surface.
myiso <- raster::rasterFromXYZ(isoscape)
myiso_sd <- rasterFromXYZ(isoscape_sd)
exampleSurface <- isotopeAssignmentModel(
         ID = "A",
         isotopeValue = -100,
         SD_indv = 5,
         precip_raster = myiso,
         precip_SD_raster = myiso_sd,
         nClusters = FALSE
         )
# Calculate odds ratio at specific point.
set.seed(1)
x <- sample( which( !is.na(exampleSurface[]) ), size = 1)
pt <- raster::xyFromCell(exampleSurface, x)
cumsumAtSamplingLocation(indivraster = exampleSurface, Lat = pt[2], Lon = pt[1])

}
\seealso{
\code{\link{makecumsumSurface}}
}
