% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup.hypothesis.R
\name{setup.hypothesis}
\alias{setup.hypothesis}
\title{Setup null and alternative hypothesis}
\usage{
setup.hypothesis(type, altpars = NULL, nullpars = NULL)
}
\arguments{
\item{type}{preset, e.g. '1PLvs2PL'. Either a string for an existing preset or a list with the required functions for a custom  preset. See the section extending the package for a tutorial on how to create a custom preset.}

\item{altpars}{List of model parameters following the alternative hypothesis. The format depends on the preset. When parameters are derived from observed data by mirt, the coef_short function can be used to convert the parameters to the right format.}

\item{nullpars}{List of model parameters following the null hypothesis. The format depends on the preset. Null parameters are not necessary for some hypothesis presets, e.g. 1PLvs2PL.}
}
\value{
a list specifying the hypothesis for usage in further functions, e.g. estimation of the noncentrality parameters.
}
\description{
Setup null and alternative hypothesis
}
\examples{
\donttest{

library(mirt)
dat <- expand.table(LSAT7)
mirtfit <- mirt(dat,1,verbose = FALSE)
hyp <- setup.hypothesis(type = '1PLvs2PL', altpars = mirtfit)
}
}
