% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{calc.time}
\alias{calc.time}
\title{Calculate the computation time needed for the analytical method}
\usage{
calc.time(hyp, n.items)
}
\arguments{
\item{hyp}{Hypothesis object as created by the setup.hypothesis function}

\item{n.items}{Number of items}
}
\value{
Numeric, estimated time in seconds
}
\description{
Calculate the computation time needed for the analytical method
}
\examples{
\donttest{
library(mirt)
dat <- expand.table(LSAT7)
mirtfit <- mirt(dat,1,verbose = FALSE)
hyp <- setup.hypothesis(type = '1PLvs2PL', altpars = mirtfit)
calc.time(hyp,n.items=7)
}
}
