% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.irtpwrresult.R
\name{summary.irtpwrresult}
\alias{summary.irtpwrresult}
\title{Summary of the Power Analysis}
\usage{
\method{summary}{irtpwrresult}(object, ..., power = NULL, N = NULL, alpha = NULL)
}
\arguments{
\item{object}{Object of class irtpwrresult as created by the irtpwr function}

\item{...}{additional arguments to be passed}

\item{power}{numeric, statistical power for which the necessary sample size is calculated}

\item{N}{integer, sample size for which the statistical power is calculated.}

\item{alpha}{numeric, alpha level}
}
\value{
An object of class summary.irtpwrresult
}
\description{
Output the resulting power or sample size for each statistic
}
\examples{
\donttest{

library(mirt)
dat <- expand.table(LSAT7)
mirtfit <- mirt(dat,1,verbose = FALSE)
hyp <- setup.hypothesis(type = '1PLvs2PL', altpars = mirtfit)
res <- irtpwr(hyp=hyp,alpha=.05,power =.8)
summary(res)
}
}
