% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ability.R
\name{ability}
\alias{ability}
\title{Estimate ability}
\usage{
ability(resp, ip, method = "WLE", mu = 0, sigma = 1, n = 5)
}
\arguments{
\item{resp}{A matrix of responses: persons as rows, items as columns,
entries are either 0 or 1, no missing data}

\item{ip}{Item parameters: the object returned by \eqn{est}.}

\item{method}{One of: "MLE", "BME", "WLE", "EAP", "PV", "QRS", "SUM"}

\item{mu}{Mean of the apriori distribution when applicable}

\item{sigma}{Standard deviation of the apriori distribution when applicable
\code{method="ML"}. Default is 1.}

\item{n}{The number of plausible values to draw for each person (default is
5).}
}
\value{
Depends on the method.
}
\description{
A wrapper around all functions for ability estimation
}
\examples{

theta <- ability(resp=Scored, method="WLE", ip=Scored2pl)

}
\seealso{
\code{\link{mlebme}}, \code{\link{eap}}, \code{\link{wle}}, \code{\link{dpv}}, \code{\link{qrs}}
}
\author{
Ivailo Partchev
}
\keyword{models}
