% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonpar.R
\name{irfPlot}
\alias{irfPlot}
\title{Item fit plot}
\usage{
irfPlot(resp, ip, x = NULL, item,
  main = "Parametric vs non-parametric trace line", use.sm = FALSE)
}
\arguments{
\item{resp}{A matrix of responses: persons as rows, items as columns,
entries are either 0 or 1, no missing data}

\item{ip}{Item parameters: the object returned by function \code{est} -- 
note that the complete object is required since the standard errors play an important part.}

\item{x}{A vector of abilities, as long as there are persons, against which to plot
probabilities of a correct response. Normally these would be the output of \code{qrs},
and these are provided by default when x is NULL. However, the user may want to use 
something else, or pass the same \code{qrs} output to several plots (various calls to
\code{qrs} provide slightly different output because of the random breaking of ties.)}

\item{item}{The item for which a plot is requested (column of \code{resp}).}

\item{main}{The main title of the plot.}

\item{use.sm}{When TRUE, empirical data will be shown with a regression estimated
by \code{sm}, otherwise the Bayes theorem will be used. Default is FALSE.}
}
\description{
Produces a plot that compares the estimated trace line (item response function)
for an item with the data. The data is represented with a non-parametric
trace line computed as in \code{tgf} (not \code{npp}). Approximate confidence
intervals for the parametric line are also shown.
}
\details{
Comparing the outputs of \code{npp} and \code{irf} has at least two drawbacks:
(i) package \code{sm} is used as a black box, and (ii) the confidence intervals
are drawn around the data (even though represented by the nonparametric regression)
rather than the parametric curve. In this function, the parametric curve is shown in
red, with a 68% confidence interval in pink and a 95% confidence interval in paler pink.
The non-parametric curve representing the data is shown in black. It is computed 
by applying Bayes theorem to the density of ability.
The standard error of the parametric curve is computed by
applying the delta theorem on the standard error of the item parameters, as computed 
by the underlying software (currently only available with ICL).
}
\examples{

# a plot for item 5 
irfPlot(Scored, ip=b3, item=4)

}
\author{
Ivailo Partchev
}
\seealso{
\code{\link{irf}}, \code{\link{npp}}, \code{\link{tgf}}
}

