% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response-class-methods.R
\name{response}
\alias{response}
\title{Create a Response object from a vector of responses}
\usage{
response(
  score = NULL,
  examinee_id = NULL,
  item_id = NULL,
  raw_response = NULL,
  testlet_id = NULL,
  order = NULL,
  response_time = NULL,
  misc = NULL
)
}
\arguments{
\item{score}{A numeric vector holding the scores given to items.}

\item{examinee_id}{Examinee/Subject/Student ID. A character string to identify
an examinee.}

\item{item_id}{A character vector holding the item IDs.}

\item{raw_response}{A vector of strings holding the raw responses to items.}

\item{testlet_id}{A character vector holding the testlet IDs that given item
belongs. It can be \code{NULL} if none of the items belongs to any testlet.
Items that do not belong to any testlet should be represented by \code{NA}.}

\item{order}{An integer vector representing the administration order of an
item.}

\item{response_time}{A numeric vector representing the response times. By
default, numbers are assumed to represent seconds.}

\item{misc}{A list that will hold miscellaneous information about the
responses. For example, code{misc = list(item_role = c("O", "O", "O","F"))}
will hold whether administered item is a field test or an operational test
item.}
}
\description{
Create a Response object from a vector of responses
}
\author{
Emre Gonulates
}
