% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat_sim_helper_functions.R
\name{get_cat_response_data}
\alias{get_cat_response_data}
\title{Extracts the response data of CAT output.}
\usage{
get_cat_response_data(
  cat_sim_output,
  cd = NULL,
  remove_na = FALSE,
  attach_summary = FALSE
)
}
\arguments{
\item{cat_sim_output}{This is a list object containing elements that are
"cat_output" class.}

\item{cd}{A \code{cat_design} object that is created by function
\code{create_cat_design}.}

\item{remove_na}{If \code{TRUE}, the columns that are all \code{NA} will be
removed.}

\item{attach_summary}{If \code{TRUE}, the summary of each CAT will be
attached to the beginning of the response string as columns. The default
value is \code{FALSE}.}
}
\value{
This function returns a response matrix of adaptive tests. If the
input is a list of \code{cat_output}, then the rows will represent examinees
and columns will represent items. For single \code{cat_output} object the
vector names will be the element
}
\description{
This function extracts the response data from a single
\code{cat_output} object or a list of \code{cat_output} objects and gives
either a vector (if there is a single \code{cat_output} object) or a matrix
(if there is a lit of \code{cat_output} objects) of response data.

If \code{cd}, cat design, object is given, then the item pool in the
\code{cd} will be used.
}
\examples{
n <- 40 # number of items
ip <- generate_ip(n = n,
                  content = sample(c("Algebra", "Arithmetic", "Geometry"),
                                   n, replace = TRUE))
cd <- create_cat_design(ip = ip, next_item_rule = 'mfi',
                        termination_rule = 'max_item',
                        termination_par = list(max_item = 10))
cat_data <- cat_sim(true_ability = rnorm(10), cd = cd)
get_cat_response_data(cat_sim_output = cat_data, cd)

}
\seealso{
\code{\link{cat_sim}}
}
\author{
Emre Gonulates
}
