% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.R
\name{band1_backsolve}
\alias{band1_backsolve}
\title{Backsolve with band 1 upper Cholesky.}
\usage{
band1_backsolve(U, z)
}
\arguments{
\item{U}{An upper triangular square matrix with non-zero entries only on the
main diagonal and the first superdiagonal.}

\item{z}{A vector with as many elements as the number of rows of U.}
}
\value{
A vector.
}
\description{
Backsolve with band 1 upper Cholesky.
}
\examples{
Q <- ar1_prec_irregular(c(1, 3:4, 6), 0.5, 1)
U <- chol_tridiag_upper(Q)
z <- rnorm(nrow(U))
band1_backsolve(U, z)
}
