% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale.R
\name{scale_doy}
\alias{scale_doy}
\title{Scale DOY}
\usage{
scale_doy(DT, doy = "DayOfYear")
}
\arguments{
\item{DT}{data.table of NDVI time series}

\item{doy}{julian day column. default is 'DayOfYear'. integer type.}
}
\value{
data.table with appended 't' column of 0-1 scaled day of year.
}
\description{
Scale the day of the year to 0-1 (like NDVI).
}
\examples{
# Load data.table
library(data.table)

# Read in example data
ndvi <- fread(system.file("extdata", "ndvi.csv", package = "irg"))

# Scale DOY
scale_doy(ndvi)
}
\seealso{
Other scale: \code{\link{scale_ndvi}}
}
\concept{scale}
