% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyverse.R
\name{rowwise.ir}
\alias{rowwise.ir}
\title{Group input \code{ir} objects by rows}
\source{
\code{\link[dplyr:rowwise]{dplyr::rowwise()}}
}
\usage{
rowwise.ir(.data, ...)
}
\arguments{
\item{.data}{Input data frame.}

\item{...}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Variables to be preserved
when calling \code{\link[dplyr:summarise]{summarise()}}. This is typically a set of variables whose
combination uniquely identify each row.

\strong{NB}: unlike \code{group_by()} you can not create new variables here but
instead you can select multiple variables with (e.g.) \code{everything()}.}

\item{data}{An object of class \code{ir}.}
}
\value{
\code{data} as row-wise data frame. See \code{\link[dplyr:rowwise]{dplyr::rowwise()}}.
}
\description{
Group input \code{ir} objects by rows
}
\examples{
## rowwise
dplyr::rowwise(ir_sample_data) \%>\%
  dplyr::mutate(
    hkl =
      mean(
        units::drop_units(klason_lignin),
        units::drop_units(holocellulose)
      )
  )


}
\seealso{
Other tidyverse: 
\code{\link{arrange.ir}()},
\code{\link{distinct.ir}()},
\code{\link{extract.ir}()},
\code{\link{filter-joins}},
\code{\link{filter.ir}()},
\code{\link{group_by}},
\code{\link{mutate-joins}},
\code{\link{mutate}},
\code{\link{nest}},
\code{\link{pivot_longer.ir}()},
\code{\link{pivot_wider.ir}()},
\code{\link{rename}},
\code{\link{select.ir}()},
\code{\link{separate.ir}()},
\code{\link{separate_rows.ir}()},
\code{\link{slice}},
\code{\link{summarize}},
\code{\link{unite.ir}()}
}
\concept{tidyverse}
