% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_files.R
\name{ipums_list_files}
\alias{ipums_list_files}
\title{List files contained within an IPUMS extract}
\usage{
ipums_list_files(
  file,
  file_select = NULL,
  types = NULL,
  data_layer = deprecated(),
  shape_layer = deprecated(),
  raster_layer = deprecated()
)
}
\arguments{
\item{file}{Path to a .zip archive or directory containing the IPUMS extract
to be examined.}

\item{file_select}{If the path in \code{file} contains multiple files, a
\link[=selection_language]{tidyselect selection} identifying the files to be
included in the output. Only files that match the provided expression
will be included.

While less useful, this can also be provided as a string specifying an
exact file name or an integer to match files by index position.}

\item{types}{One or more of \code{"data"} or \code{"shape"} indicating
the type of files to include in the output. \code{"data"} refers to
tabular data sources, while \code{"shape"} refers to spatial data sources.

The use of \code{"raster"} has been deprecated and will be removed in a
future release.}

\item{data_layer, shape_layer, raster_layer}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
Please use \code{file_select} instead.}
}
\value{
A \code{\link[tibble:tbl_df-class]{tibble}} containing the types and names of
the available files.
}
\description{
Identify the files that can be read from an IPUMS extract, whether its
files are stored in a .zip archive or a directory.
}
\examples{
nhgis_file <- ipums_example("nhgis0712_csv.zip")

# 2 available files in this extract
ipums_list_files(nhgis_file)

# Look for files that match a particular pattern:
ipums_list_files(nhgis_file, file_select = matches("ds136"))
}
\seealso{
\code{\link[=read_ipums_micro]{read_ipums_micro()}} or \code{\link[=read_nhgis]{read_nhgis()}} to read tabular data
from an IPUMS extract.

\code{\link[=read_ipums_sf]{read_ipums_sf()}} to read spatial data from an IPUMS extract.
}
