% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{define_extract_usa}
\alias{define_extract_usa}
\title{Define an IPUMS USA extract request}
\usage{
define_extract_usa(
  description,
  samples,
  variables,
  data_format = c("fixed_width", "csv", "stata", "spss", "sas9"),
  data_structure = "rectangular",
  rectangular_on = "P"
)
}
\arguments{
\item{description}{Description of the extract.}

\item{samples}{Character vector of samples to include in the extract. Samples
should be specified using the
\href{https://usa.ipums.org/usa-action/samples/sample_ids}{sample ID values}.}

\item{variables}{Character vector of variables to include in the extract.}

\item{data_format}{The desired format of the extract data file (one of
"fixed_width", "csv", "stata", "spss", or "sas9").}

\item{data_structure}{Currently, this must be "rectangular", which is also
the default. In the future, the API will also support "hierarchical"
extracts.}

\item{rectangular_on}{Currently, this must be "P", indicating that the
extract will be rectangularized on person records. In the future, the API
will also support household-only extracts (\code{rectangular_on = "H"}).}
}
\value{
An object of class \code{\link[=ipums_extract-class]{c("usa_extract", "ipums_extract")}}
containing the extract definition.
}
\description{
Define an IPUMS USA extract request to be submitted via the IPUMS microdata
extract API. For an overview of ipumsr microdata API functionality, see
\code{vignette("ipums-api", package = "ipumsr")}.
}
\examples{
my_extract <- define_extract_usa("Example", "us2013a", "YEAR")
}
\seealso{
Other ipums_api: 
\code{\link{add_to_extract}()},
\code{\link{define_extract_cps}()},
\code{\link{define_extract_from_json}()},
\code{\link{download_extract}()},
\code{\link{extract_list_to_tbl}()},
\code{\link{extract_tbl_to_list}()},
\code{\link{get_extract_info}()},
\code{\link{get_last_extract_info}()},
\code{\link{get_recent_extracts_info}},
\code{\link{ipums_data_collections}()},
\code{\link{is_extract_ready}()},
\code{\link{remove_from_extract}()},
\code{\link{save_extract_as_json}()},
\code{\link{set_ipums_api_key}()},
\code{\link{submit_extract}()},
\code{\link{wait_for_extract}()}
}
\concept{ipums_api}
