% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overview.R
\encoding{UTF-8}
\name{overview}
\alias{overview}
\title{Calcul de l’aperçu global : overview.}
\usage{
overview(
  data,
  date,
  x,
  unite = 1,
  decimal = 0,
  cumul = FALSE,
  freq = "jour",
  facteur
)
}
\arguments{
\item{data}{Un objet de type data.frame contenant au minimum la serie numerique et un vecteur de type date.}

\item{date}{La date jusqu’à laquelle on vq sommer les valeur de la série depuis le début de l'année.}

\item{x}{Un vecteur de type numeric contenant les observations du phénomène à etudier.}

\item{unite}{Un valeur de type numeric, definissant l'ordre d'echelle d'affisage du resultat de la fonction. Sa valeur par defaut est \code{1}.}

\item{decimal}{Un objet de type numeric permettant de préciser le nombre d'entier à afficher après la virgule. Sa valeur par defaut est \code{0}.}

\item{cumul}{Un objet de type logic qui permet d'indiquer si le vecteur \code{x} contient des valeurs cumulées. Sa valeur par defaut est \code{FALSE}.}

\item{freq}{Un objet de type character qui permet d'indiquer si la vue globale est faite sur une frequence journalière ou mensuelle. Sa valeur par defaut est \code{jour}.}

\item{facteur}{Un objet de type factor ou charcter qui permet d'indiquer si le vecteur \code{x} contient des valeurs répétées.}
}
\value{
Un vecteur de longieur 1.
}
\description{
Cette fonction permet de donner un résumé sur les performances d'une série par rapport à une date introduit par l'utilisateur.
}
\examples{
x <- rnorm(600, mean = 50, sd = 6.3)
date <- seq.Date(as.Date("2022-01-01"), by = "day", length.out = 600)
df <- data.frame(date, x)
overview(df, date = "2023-05-30", x = "x")
overview(df, date = "2023-04-25", x = "x", decimal = 2)

}
