% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{summary.ipd}
\alias{summary.ipd}
\title{Summarize IPD Fit}
\usage{
\method{summary}{ipd}(object, ...)
}
\arguments{
\item{object}{An object of class \code{ipd}.}

\item{...}{Additional arguments to be passed to the summary function.}
}
\value{
A list containing:

\describe{

\item{coefficients}{Model coefficients and related statistics.}

\item{performance}{Performance metrics of the model fit.}

\item{...}{Additional summary information.}
}
}
\description{
Produces a summary of the IPD method/model combination.
}
\examples{

#-- Generate Example Data

set.seed(2023)

dat <- simdat(n = c(300, 300, 300), effect = 1, sigma_Y = 1)

head(dat)

formula <- Y - f ~ X1

#-- Fit IPD

fit <- ipd(formula, method = "postpi_analytic", model = "ols",

  data = dat, label = "set")

#-- Summarize Output

summ_fit <- summary(fit)

summ_fit

}
