% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cens.ipw.R
\name{cens.ipw}
\alias{cens.ipw}
\title{Censoring patient initiating the other arm treatment and building a treatment censoring indicator cens}
\usage{
cens.ipw(
  data,
  id,
  tstart,
  tstop,
  event,
  censTime,
  arm,
  realtrt = FALSE,
  trt.start = NULL,
  trt.stop = NULL
)
}
\arguments{
\item{data}{a dataframe containing the following variables}

\item{id}{the patient's id}

\item{tstart}{the date of the beginning of the follow-up (in numeric format)}

\item{tstop}{the date of the end of the follow-up (in numeric format)}

\item{event}{the indicator of failure (a death is denoted by 1 at the end of the follow-up)}

\item{censTime}{the chosen time to censor the patients (in numeric format)}

\item{arm}{the randomized treatment (2-levels factor)}

\item{realtrt}{the randomized treatment (2-levels factor)}

\item{trt.start}{the time of initiation of the randomized treatment (NULL by default)}

\item{trt.stop}{the time of termination of the randomized treatment (NULL by default)}
}
\value{
a dataframe in the long format, with the data being censored
 according to the input date, censTime. a treatment censoring indicator, cens,
 is thus added to the previous dataset to indicate such a switch.
 Note that this function provides the option to include in the data
 the treatment really taken with the corresponding dates.
 Then, the treatment really taken is a 3-levels factor,
 i.e., the two from the randomized arms and a third indicating
 the no-treatment case (None).
}
\description{
Censoring patient initiating the other arm treatment and building a treatment censoring indicator cens
}
\examples{
# To obtain the times parameter, we can apply the timesTokeep function on the same
# dataframe in the wide format
kept.t <- timesTokeep(toydata, id = "id",
tstart = "randt", tstop = "lastdt",
mes.cov = list(c("ps1", "ps2", "ps3")),
time.cov = list(c("randt", "dt2", "dt3")))
# Now, we can build the long format
toy.long <- wideToLongTDC(data = toydata, id = "id",
tstart = "randt", tstop = "lastdt", event = "status",
bas.cov = c("age", "arm", "swtrtdt"),
mes.cov = list(TDconf = c("ps1", "ps2", "ps3")),
time.cov = list(c("randt", "dt2", "dt3")),
times = kept.t[[1]])
# Put dates in numeric format with tstart at 0
toy.long$tstart <- as.numeric(toy.long$tstart)
toy.long$tstop <- as.numeric(toy.long$tstop)
toy.long$swtrtdt <- as.numeric(toy.long$swtrtdt)
tabi <- split(toy.long, toy.long$id)
L.tabi   <- length(tabi)
tablist <- lapply(1:L.tabi, function(i){
    refstart <- tabi[[i]]$tstart[1]
    tabi[[i]]$tstart  <- tabi[[i]]$tstart - refstart
    tabi[[i]]$tstop <- tabi[[i]]$tstop - refstart
    tabi[[i]]$swtrtdt <- tabi[[i]]$swtrtdt - refstart
    return(tabi[[i]])
    })
    toy.long <- do.call( rbind, tablist )
# Patients are censored when initiating the other arm treatment, that is, at time swtrtdt
toy.long2 <- cens.ipw(toy.long, id = "id", tstart = "tstart", tstop = "tstop",
event = "event", arm = "arm",
realtrt = FALSE, censTime ="swtrtdt")
# Before censoring:
toy.long
# Ater censoring:
toy.long2
}
\references{
Graffeo, N., Latouche, A., Le Tourneau C., Chevret, S. (2019) "ipcwswitch: an R package for inverse probability of censoring weighting with an application to switches in clinical trials". Computers in biology and medicine, 111, 103339. doi : "10.1016/j.compbiomed.2019.103339"
}
\seealso{
\code{\link{SHIdat}}, \code{\link{timesTokeep}}, \code{\link{wideToLongTDC}}
}
