% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wideToLongTDC.R
\name{wideToLongTDC}
\alias{wideToLongTDC}
\title{Function from wide to long format}
\usage{
wideToLongTDC(data, id, tstart, tstop, event, bas.cov, mes.cov, time.cov,
  times)
}
\arguments{
\item{data}{a dataframe containing the variables id, tstart, tstop, mes.cov and time.cov}

\item{id}{the patient's id}

\item{tstart}{date of the beginning of the follow-up (in Date format)}

\item{tstop}{date of the end of the follow-up (in Date format)}

\item{event}{the indicator of failure (a death is denoted by 1 at the end of the follow-up)}

\item{bas.cov}{a vector containing the names (in character format) of the baseline covariates}

\item{mes.cov}{a list of vectors, each of them must contain the names (in character format)
of the repeated measurements related to one time-dependent covariate}

\item{time.cov}{a list of vectors, each of them must contain the times (in Date format)
of the date when the abovementioned measurements were done}

\item{times}{a list of vectors. Each of them must contain, for each patient,
the event time and the times of changes in time-varying covariates}
}
\value{
the long format version of the initial dataframe data. The repeated values
included in each vector of the list mes.cov are aggregated in a variable named
aas the name of the corresponding list member.
}
\description{
Function from wide to long format
}
\examples{
# To obtain the times parameter, we can apply the timesTokeep function on the same
# dataframe in the wide format
kept.t <- timesTokeep(toydata, id = "id",
tstart = "randt", tstop = "lastdt",
mes.cov = list(c("ps1", "ps2", "ps3")),
time.cov = list(c("randt", "dt2", "dt3")))
# Now, we can build the long format
toy.long <- wideToLongTDC(data = toydata, id = "id",
tstart = "randt", tstop = "lastdt", event = "status",
bas.cov = c("age", "arm", "swtrtdt"),
mes.cov = list(TDconf = c("ps1", "ps2", "ps3")),
time.cov = list(c("randt", "dt2", "dt3")),
times = kept.t[[1]])
toy.long
}
\references{
Graffeo, N., Latouche, A., Le Tourneau C., Chevret, S. "An R Package for IPCW: Application to switches in clinical trials" \emph{(submitted)}
}
\seealso{
\code{\link{data.ipcw}}, \code{\link{timesTokeep}}
}
