% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiplier_create.R
\name{multiplier_create}
\alias{multiplier_create}
\title{Create multipliers}
\usage{
multiplier_create(
  input_vector,
  Im,
  multiplier_name = "multiplier",
  digits = NULL
)
}
\arguments{
\item{input_vector}{An input matrix or vector created by the 
\code{\link{input_indicator_create}} function.}

\item{Im}{The Leontief inverse as a named object created by the 
\code{\link{leontief_inverse_create}} function.}

\item{multiplier_name}{A variable name to be given to the returned multipliers. 
Defaults to \code{multiplier}.}

\item{digits}{Rounding digits, if omitted, no rounding takes place.}
}
\value{
A data frame with the vector of multipliers and the an 
auxiliary metadata column (for joining with other matrixes.)
}
\description{
This function is in fact a wrapper around the \code{\link{equation_solve}} function, 
adding a key column with the name to the multiplier the maintain structural
consistency.
}
\details{
As opposed to direct effects, multipliers are expressed per input of
product/industry.
}
\examples{
data_table <- iotable_get()

coeff_de <- input_coefficient_matrix_create( data_table )

de_gva_indicator <- input_indicator_create (
  data_table = data_table, 
  input = 'gva')  #this is a correct input

I_de <- leontief_inverse_create( coeff_de )

de_gva_multipliers <- multiplier_create ( 
  input_vector    = de_gva_indicator,
  Im              = I_de,
  multiplier_name = "employment_multiplier", 
  digits = 4 )

}
\seealso{
Other multiplier functions: 
\code{\link{input_multipliers_create}()}
}
\concept{multiplier functions}
