% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_knitr_table.R
\name{create_knitr_table}
\alias{create_knitr_table}
\title{Create an output-independent, well formatted kable table}
\usage{
create_knitr_table(data_table, digits = NULL, caption = NA,
  col.names = NULL, col_width = NULL, width_unit = "cm",
  col_align = NULL, border_right_cols = NULL, bold_cols = NULL,
  bootstrap_options = c("striped", "hover", "condensed"),
  latex_options = NULL, output_format = NULL, keep_pdf = FALSE,
  latex_header_includes = c("\\\\usepackage[magyar]{babel}",
  "\\\\usepackage[utf8]{inputenc}"))
}
\arguments{
\item{data_table}{data.frame, tibble, named matrix or a knitr_kable object.}

\item{digits}{Number of digits to display in the case of numeric variables.}

\item{caption}{A table caption, defaults to empty \code{NA}.}

\item{col.names}{The col.names parameter of the kable table, if \code{NULL},
filled with the names of the \code{data_table}.}

\item{col_width}{Defaults to \code{NULL}. In this case all col_align parameters
will be \code{"c"} for centered.}

\item{width_unit}{Defaults to \code{"cm"}.}

\item{col_align}{Defaults to \code{NULL}. In this case \code{'l'} for the
first column and \code{'r'} for the rest of the columns, 
i.e.\code{"l", "c", ..., "c"}}

\item{border_right_cols, }{Defaults to \code{NULL}. 
In this case \code{TRUE} for the first column and \code{FALSE}
for the rest of the columns, i.e.\code{T, F, ..., F}}

\item{bold_cols}{Defaults to \code{NULL}. In this case none of the 
the columns are bold, i.e. identical to \code{F, F, ..., F}.}

\item{bootstrap_options}{Defaults to \code{c("striped", "hover", "condensed")} and
only used for \code{output_format = "html"}.}

\item{latex_options}{Defaults to \code{NULL)}.}

\item{output_format}{Defaults to \code{'html'}. Alternatives are \code{'latex'} and
\code{'image'}, recommended for Word files.}

\item{keep_pdf}{Defaults to  \code{FALSE} and only used if \code{output_format = 'image'}.}

\item{latex_header_includes}{Currently defaults to \code{c(
"\\usepackage[magyar]{babel}",
"\\usepackage[utf8]{inputenc}")}
It can be any valid latex option setting, but if packages are used, the 
packages must be installed on your Latex engine.}
}
\description{
Create an output-independent, well formatted kable table
}
\examples{
foo = data.frame ( 
  observation = c("indicator1", "indicator2", "indicator3"), 
  indicator_1 = c(100,105,95), 
  indicator_2 = c(102,104,76)
  )
}
