% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cp_2comp_dt.R
\name{cp_2comp_dt}
\alias{cp_2comp_dt}
\title{Time derivative of analytical 2-compartment model}
\usage{
cp_2comp_dt(params, time, dose, route, medium)
}
\arguments{
\item{params}{A named list of parameter values including the following:
  \describe{
  \item{k12}{Rate at which compound moves from central to peripheral
  compartment, 1/h.}
  \item{k21}{Rate at which compound moves from peripheral to central
  compartment, 1/h.}
  \item{kelim}{Elimination rate, 1/h.}
  \item{V1}{Apparent volume of central compartment, L/kg BW. Or see below for
  "Fgutabs_V1"}
  }

 For oral administration (`route %in% "oral"`), \code{params} must also
 include:
  \describe{
  \item{Fgutabs}{Oral bioavailability, unitless fraction. Or see below for
  "Fgutabs_V1"}
  \item{kgutabs}{Rate of absorption from gut, 1/h.}
  }

 For oral administration, in lieu of "V1" and "Fgutabs", you may instead
 provide "Fgutabs_V1", the ratio of Fgutabs to V1 (1/L). This is an alternate
 parameterization for situations where "Fgutabs" and "V1" are not
 identifiable separately (i.e. when oral data are available, but IV data are
 not). If "Fgutabs" and "V1" are provided, then "Fgutabs_V1" will not be
 used.}

\item{time}{A numeric vector of times in hours, reflecting the time points
when concentration is measured after the corresponding single bolus dose.
Must be same length as `dose` and `route`, or length 1.}

\item{dose}{A numeric vector of doses in mg/kg, reflecting single bolus doses
administered at time 0. Must be same length as `time` and `route`, or length
1.}

\item{route}{A character vector, reflecting the route of administration of
each single bolus dose. Currently, only "iv" and "oral" are supported. Must
be same length as `time` and `dose`, or length 1.}

\item{medium}{A character vector reflecting the medium in which each resulting
concentration is to be calculated: "blood" or "plasma". Default is "plasma".
Must be same length as `time` and `dose`, or length 1.}
}
\value{
A vector of instantaneous rates of change of plasma concentration
 values (mg/L/time) corresponding to each value in \code{time}
}
\description{
Calculates the time derivative (instantaneous rate of change) of plasma
concentration according to the analytical solution for the 2-compartment
model.
}
\details{
This function is used by [postprocess_data()] to determine the time of peak
concentration for the 2-compartment model, by locating the point where the
time derivative of concentration crosses zero.
}
\seealso{
Other built-in model functions: 
\code{\link{auc_1comp}()},
\code{\link{auc_1comp_cl}()},
\code{\link{auc_2comp}()},
\code{\link{auc_flat}()},
\code{\link{cp_1comp}()},
\code{\link{cp_1comp_cl}()},
\code{\link{cp_2comp}()},
\code{\link{cp_flat}()},
\code{\link{get_params_1comp}()},
\code{\link{get_params_1comp_cl}()},
\code{\link{get_params_1comp_fup}()},
\code{\link{get_params_2comp}()},
\code{\link{get_params_flat}()},
\code{\link{get_starts_1comp}()},
\code{\link{get_starts_1comp_cl}()},
\code{\link{get_starts_1comp_fup}()},
\code{\link{get_starts_2comp}()},
\code{\link{get_starts_flat}()},
\code{\link{tkstats_2comp}()},
\code{\link{transformed_params_2comp}()}

Other 2-compartment model functions: 
\code{\link{auc_2comp}()},
\code{\link{cp_2comp}()},
\code{\link{get_params_2comp}()},
\code{\link{get_starts_2comp}()},
\code{\link{tkstats_2comp}()},
\code{\link{transformed_params_2comp}()}
}
\author{
Caroline Ring, John Wambaugh
}
\concept{2-compartment model functions}
\concept{built-in model functions}
