% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_product_optimization.R
\name{single_product_optimization}
\alias{single_product_optimization}
\title{single_product_optimization}
\usage{
single_product_optimization(x, y, service_product_name, current_price, cost)
}
\arguments{
\item{x}{a vector of average weekly/monthly/daily price data of a product}

\item{y}{a vector of average weekly/monthly/daily sales data of a product}

\item{service_product_name}{the name of the product or service.}

\item{current_price}{the current price of the product or service.}

\item{cost}{cost of the product.}
}
\value{
a list of the squared error of th logit model, the squared error of the linear model, the best model for this product, the optimum
price for both the linear and the logit model, the current price,the a,b,c parameters of th logit model,the linear model paremeters ,
data simulated
at different price points and th expected revenue and the fitting results of both the logit and linear model.
}
\description{
Calculating the optimum price based on linear and logit models for a single product.
}
\details{
calculate the optimized price based on the price response function. the price response function is measured twice, one with linear model and
one time with a logit model. a simulation is then made with each price response function to define the maximum revenue for each.
 finally, a suggestion of which model to choose and the optimum price to use for this product.
 it is preferable to de-seasonalize the sales data before fitting if the sales
 are affected by spikes and declines due to regular events as holidays and weekends.
}
\examples{
single_product_optimization(x= c(5,8,10,12),
y=c(25,21,23,15),
service_product_name = "Goat Cheese",current_price = 8.5,cost=7)
}
\author{
"haytham omar  email: <haytham@rescaleanalytics.com>"
}
