% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ivLT.R
\name{L.t}
\alias{L.H}
\alias{L.cos}
\alias{L.exp}
\alias{L.sin}
\alias{L.t}
\alias{L.tsq}
\title{Laplace Transforms}
\usage{
L.t(p)

L.tsq(p)

L.exp(p)

L.cos(p)

L.sin(p)

L.H(p)
}
\arguments{
\item{p}{Laplace domain variable (commonly called \eqn{s} elsewhere)}
}
\description{
Laplace Transforms of common functions.  Useful for testing out LT inversion functions and whether sufficient precision is being used.
}
\section{Functions}{
\itemize{
\item \code{L.t}: LT of \eqn{t}

\item \code{L.tsq}: LT of \eqn{t^2}

\item \code{L.exp}: LT of \eqn{e^(-t)}

\item \code{L.cos}: LT of cos\eqn{(t)}

\item \code{L.sin}: LT of sin\eqn{(t)}

\item \code{L.H}: LT of Heaviside unit function stepping at 1: (if \eqn{p < 1} 0 else 1)
}}

