% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ia_download.R
\name{ia_download}
\alias{ia_download}
\title{Download files for Internet Archive items.}
\usage{
ia_download(files, dir = ".", extended_name = TRUE, overwrite = FALSE,
  silence = FALSE)
}
\arguments{
\item{files}{A data frame of files returned by \link{ia_files}. You should
filter this data frame to download only the files that you actually want.}

\item{dir}{The directory in which to save the downloaded files.}

\item{extended_name}{If this argument is \code{FALSE}, then the downloaded
file will have a filename in the following format:
\code{itemidentifier.extension}, e.g., \code{thedamnationofth00133gut.txt}.
If there are multiple files of the same file type for an item, then the
file names will not be unique. If this argument is \code{TRUE}, them the
downloaded file will have a filename in the following format:
\code{itemidentifier-original-filename.extension}, e.g.,
\code{thedamnationofth00133gut-133.txt}.}

\item{overwrite}{If \code{TRUE}, this function will download all files and
overwrite them on disk if they have already been downloaded. If
\code{FALSE}, then if a file already exists on disk it will not be
downloaded again but other downloads will proceed normally.}

\item{silence}{If false, print the item IDs as they are downloaded.}
}
\value{
A data frame including the file names of the downloaded files.
}
\description{
Download files for Internet Archive items.
}
\examples{
\dontrun{
if (require(dplyr)) {
  dir <- tempdir()
  ia_get_items("thedamnationofth00133gut") \%>\%
    ia_files() \%>\%
    filter(type == "txt") \%>\% # download only the files we want
    ia_download(dir = dir, extended_name = FALSE)
}
}
}

