\docType{package}
\name{intergraph-package}
\alias{intergraph-package}
\title{Coercion routines for network data objects in R}
\description{
  This package contains methods for coercion between
  various classes used to represent network data in R.
}
\details{
  Functions implemented in this package allow to coerce
  (i.e. convert) network data between classes provided by
  other R packages. Currently supported classes are:
  "network" from package \pkg{network}, "igraph" from
  package \pkg{igraph}.

  The main functions are: \itemize{ \item
  \code{\link{asNetwork}} and its methods to create objects
  of class "network".

  \item \code{\link{asIgraph}} and its methods to create
  objects of class "igraph". } See their help pages for
  more information and examples.

  As all the supported packages are written using S3
  methods, so are the methods in this package.

  If you find this package useful in your work please cite
  it. Type \code{citation(package="intergraph")} for the
  information how to do that.
}
\examples{
# example of converting objects between classes 'network' and 'igraph'
# needs packages igraph and network attached
if( require(network) & require(igraph) )
{

  ### convert 'network' -> 'igraph'

  # example network as object of class "network"
  summary(exNetwork)

  # convert to class "igraph"
  g <- asIgraph(exNetwork)

  # check if 'exNetwork' and 'g' are the same
  all.equal( as.matrix(exNetwork, "edgelist"), 
    igraph::get.edgelist(g) )   

  # compare results using 'netcompare'
  netcompare(exNetwork, g)

  ### convert 'igraph' -> 'network'

  # example network as object of class "igraph"
  summary(exIgraph)

  # convert to class "network"
  gg <- asNetwork(exIgraph)

  # check if they are the same
  all.equal( get.edgelist(exIgraph), as.matrix(gg, "edgelist"))
  # compre results using 'netcompare'
  netcompare(exIgraph, g)
}
}
\author{
  Written and maintained by Michal Bojanowski
  \email{m.bojanowski@icm.edu.pl}.
}
\keyword{package}

