% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interacCircos.R
\name{CircosLine}
\alias{CircosLine}
\title{Create a LINE module to a moduleList}
\usage{
CircosLine(
  modulename,
  compareGroup = 1,
  maxRadius = 108,
  minRadius = 95,
  ValueAxisManualScale = FALSE,
  ValueAxisMaxScale = 10,
  ValueAxisMinScale = 0,
  color = "red",
  width = 2,
  type = "cardinal",
  animationDisplay = FALSE,
  animationDirection = "S2E",
  animationTime = 2000,
  animationDelay = 20,
  animationType = "bounce",
  data,
  ...
)
}
\arguments{
\item{modulename}{The name of the new module.}

\item{compareGroup}{The group number of this module in compare module}

\item{maxRadius, minRadius}{Where the module should begin and end}

\item{ValueAxisManualScale}{Whether manually control the scale of value}

\item{ValueAxisMaxScale, ValueAxisMinScale}{The max and min scale value for manually control}

\item{color}{Color for line}

\item{width}{Width for line}

\item{type}{Type for line, could be linear, cardinal, basis and monotone}

\item{animationDisplay}{Whether display animation}

\item{animationDirection}{The direction of animation, could be S2E(start to end) or E2S(end to start)}

\item{animationTime, animationDelay, animationType}{The time, delay and display type for animation}

\item{data}{A list of value with details including chr, pos, des, value and html. Details can be found on document.}

\item{...}{Ignored}
}
\value{
The module tracks for line modules.
}
\description{
Display a multi-layer line plot in circos
}
\examples{

lineData<-lineExample
Circos(CircosLine('LINE01', data = lineData,maxRadius=200,minRadius=150,color= "#ff0031")+
CircosBackground('BG01',minRadius = 205,maxRadius = 150))

}
