\name{imgCor}
\encoding{latin1}
\alias{imgCor}
\alias{imgCor.default}

\title{Image Maps of Correlation Matrices between two Data Sets}

\description{
Display two-dimensional visualizations (image maps) of the correlation matrices within and between
two data sets.
}

\usage{
	\method{imgCor}{default}(X, Y, type = c("combine", "separated"), col = jet.colors(64), ...)
}

\arguments{
  \item{X}{numeric matrix or data frame \eqn{(n \times p)}, the observations on the \eqn{X} variables.
    \code{NA}s are allowed.}
  \item{Y}{numeric matrix or data frame \eqn{(n \times q)}, the observations on the \eqn{Y} variables.
    \code{NA}s are allowed.}
  \item{type}{character string, (partially) maching one of \code{"combine"} or \code{"separated"}, 
    determining the kind of plots to be produced. See Details.}
  \item{col}{vector of colors such as that generated by 
    \code{\link{heat.colors}}, \code{\link{topo.colors}}, \code{\link{rainbow}} 
	or similar functions. Defaults to \code{\link{jet.colors}(64)}.}
  \item{...}{not used currently.}	
}

\details{
If \code{type="combine"}, the correlation matrix is computed of the combined
matrices \code{cbind(X, Y)} and then plotted. If \code{type="separated"}, 
three correlation matrices are computed, \code{cor(X)}, \code{cor(Y)} and 
\code{cor(X,Y)} and plotted separately on the same device. In both cases, 
a color correlation scales strip is plotted.

The correlation matrices are pre-processed before calling the \code{img} 
function in order to get, as in the numerical representation, the diagonal 
from upper-left corner to bottom-right one.
}

\author{Sbastien Djean and Ignacio Gonzlez.}

\seealso{\code{\link{cor}}, \code{\link{img}}, \code{\link{jet.colors}}.}

\examples{
data(nutrimouse)
X <- nutrimouse$lipid
Y <- nutrimouse$gene

## 'combine' type plot (default)
imgCor(X, Y)

## 'separate' type plot
imgCor(X, Y, type = "separate")
}

\keyword{multivariate}
\keyword{dplot}
