% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{biggest_reference}
\alias{biggest_reference}
\title{Set reference group to the group with largest exposure}
\usage{
biggest_reference(x, weight)
}
\arguments{
\item{x}{an unordered factor}

\item{weight}{a vector containing weights (e.g. exposure). Should be numeric.}
}
\value{
a factor of the same length as x
}
\description{
This function specifies the first level of a factor to the level
with the largest exposure. Levels of factors are sorted using an alphabetic
ordering. If the factor is used in a regression context, then the first level
will be the reference. For insurance applications it is common to specify
the reference level to the level with the largest exposure.
}
\examples{
\dontrun{
library(dplyr)
df <- chickwts |>
mutate(across(where(is.character), as.factor)) |>
mutate(across(where(is.factor), ~biggest_reference(., weight)))
}

}
\references{
Kaas, Rob & Goovaerts, Marc & Dhaene, Jan & Denuit, Michel.
(2008). Modern Actuarial Risk Theory: Using R. doi:10.1007/978-3-540-70998-5.
}
\author{
Martin Haringa
}
