% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_weights.R
\name{get_weights}
\alias{get_weights}
\title{Get the values from model weights}
\usage{
get_weights(x, na_rm = FALSE, ...)
}
\arguments{
\item{x}{A fitted model.}

\item{na_rm}{Logical, if \code{TRUE}, removes possible missing values.}

\item{...}{Currently not used.}
}
\value{
The weighting variable, or \code{NULL} if no weights were specified (or if all weights were 1).
}
\description{
Returns weighting variable of a model.
}
\examples{
data(mtcars)
mtcars$weight <- rnorm(nrow(mtcars), 1, .3)
m <- lm(mpg ~ wt + cyl + vs, data = mtcars, weights = weight)
get_weights(m)
}
