% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_value.R
\name{format_value}
\alias{format_value}
\title{Numeric Values Formatting}
\usage{
format_value(
  x,
  digits = 2,
  protect_integers = FALSE,
  missing = "",
  width = NULL,
  as_percent = FALSE,
  zap_small = FALSE,
  ...
)
}
\arguments{
\item{x}{Numeric value.}

\item{digits}{Number of significant digits.}

\item{protect_integers}{Should integers be kept as integers (i.e., without decimals)?}

\item{missing}{Value by which \code{NA} values are replaced. By default, an empty string (i.e. \code{""}) is returned for \code{NA}.}

\item{width}{Minimum width of the returned string. If not \code{NULL} and \code{width} is larger than the string's length, leading whitespaces are added to the string.}

\item{as_percent}{Logical, if \code{TRUE}, value is formatted as percentage value.}

\item{zap_small}{Logical, if \code{TRUE}, small values are rounded after \code{digits} decimal places. If \code{FALSE}, values with more decimal places than \code{digits} are printed in scientific notation.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A formatted string.
}
\description{
Numeric Values Formatting
}
\examples{
format_value(1.20)
format_value(1.2)
format_value(1.2012313)
format_value(c(0.0045, 234, -23))
format_value(c(0.0045, .12, .34))
format_value(c(0.0045, .12, .34), as_percent = TRUE)

format_value(as.factor(c("A", "B", "A")))
format_value(iris$Species)

format_value(3)
format_value(3, protect_integers = TRUE)

format_value(iris)
}
