% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_insee.R
\name{get_insee}
\alias{get_insee}
\title{Get data from INSEE BDM database with a SDMX query link}
\usage{
get_insee(link, step = "1/1")
}
\arguments{
\item{link}{SDMX query link}

\item{step}{argument used only for internal package purposes to tweak download display}
}
\value{
a tibble containing the data
}
\description{
Get data from INSEE BDM database with a SDMX query link
}
\details{
Get data from INSEE BDM database with a SDMX query link.
This function is mainly for package internal use.
It is used by the functions get_insee_dataset, get_insee_idbank and get_dataset_list.
The data is cached, hence all queries are only run once per R session.
The user can disable the download display in the console with the following command :
Sys.setenv(INSEE_download_verbose = "FALSE")
The use of cached data can be disabled with : Sys.setenv(INSEE_no_cache_use = "TRUE")
All queries are printed in the console with this command: Sys.setenv(INSEE_print_query = "TRUE").
By default the RapidXML C++ library is used through the readsdmx package.
The previous parser can still be used with this command : Sys.setenv(INSEE_read_sdmx_slow = "TRUE")
}
\examples{
\donttest{
insee_link = "http://www.bdm.insee.fr/series/sdmx/data/SERIES_BDM"
insee_query = file.path(insee_link, paste0("010539365","?", "firstNObservations=1"))
data = get_insee(insee_query)
}
}
