% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ino.R
\name{new_prob}
\alias{new_prob}
\title{Constructor}
\format{
A \code{prob} object is a list of six elements:
\itemize{
\item The \code{f} element is the function to be optimized.
\item The \code{npar} element is the length of the first argument of \code{f},
i.e. the argument over which \code{f} is optimized.
\item The \code{global} element is the point where \code{f} obtains its global
optimum. If it is not specified, it is \code{NULL}.
\item The \code{add} element is a named list, where each element is a list of
one (or more) additional function elements for \code{f}. The names of the
arguments with multiple parameter values are saved as the character vector
\code{mpvs} in the attributes of \code{add}.
\item The \code{f_name} element is the name of \code{f}.
\item The \code{f_target} element is the name of the first argument of \code{f}.
}
}
\usage{
new_prob(
  x = list(),
  f = function() {
 },
  npar = integer(),
  global = NULL,
  add = list(),
  mpvs = character(),
  f_name = character(),
  f_target = character()
)
}
\arguments{
\item{x}{A list.}

\item{f}{An object of class \code{function}, the function to be optimized.}

\item{npar}{The length of the first argument of \code{f}, i.e. the argument over which
\code{f} is optimized.}

\item{global}{Either \code{NULL} (default) or the point where \code{f} obtains its global
optimum (i.e., a numeric vector of length \code{npar}).}

\item{add}{A list of additional and named arguments to be passed to \code{f}.}

\item{mpvs}{A character vector of the argument names with multiple parameter values.
None per default.}

\item{f_name}{A character, the name of \code{f}.}

\item{f_target}{A character, the name of the first argument of \code{f}.}
}
\value{
An object of class \code{prob}.
}
\description{
This function constructs a \code{prob} object.
}
\details{
The \code{prob} object specifies the optimization problem.
}
\keyword{internal}
