% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_wordcloud.R
\name{make_wordcloud}
\alias{make_wordcloud}
\title{Create Word Cloud from Frequency Table of Words}
\usage{
make_wordcloud(
  x,
  max_words = 200L,
  size = 1,
  shape = "circle",
  ellipticity = 0.65,
  ...,
  width = 910L,
  output = NULL,
  display = FALSE
)
}
\arguments{
\item{x}{'data.frame'.
A frequency table of words that includes "word" and "freq" in each column.}

\item{max_words}{'integer' number.
Maximum number of words to include in the word cloud.}

\item{size}{'numeric' number.
Font size, where the larger size indicates a bigger word.}

\item{shape}{'character' string.
Shape of the \dQuote{cloud} to draw.
Possible shapes include a "circle", "cardioid", "diamond",
"triangle-forward", "triangle", "pentagon", and "star".}

\item{ellipticity}{'numeric' number.
Degree of \dQuote{flatness} of the shape to draw, a value between 0 and 1.}

\item{...}{Additional arguments to be passed to the \code{\link[wordcloud2:wordcloud2]{wordcloud2}} function.}

\item{width}{'integer' number.
Desired image width in pixels.}

\item{output}{'character' string.
Path to the output file, by default the word cloud is copied to a temporary file.}

\item{display}{'logical' flag.
Whether to display the saved PNG file in a graphics window.
Requires access to the \pkg{magick} package.}
}
\value{
File path to the word cloud plot in PNG format.
}
\description{
Create a word cloud from a frequency table of words, and save to a PNG file.
Requires R-packages \pkg{htmltools}, \pkg{htmlwidgets}, \pkg{magick}, \pkg{webshot2},
and \pkg{wordcloud2} are available.
System dependencies include the the following:
\href{https://imagemagick.org/}{ImageMagick} for displaying the PNG image,
\href{https://optipng.sourceforge.net/}{OptiPNG} for PNG file compression, and
\href{https://www.google.com/chrome/}{Chrome}- or a Chromium-based browser
with support for the Chrome DevTools protocol.
Use \code{\link[chromote:find_chrome]{find_chromate}} function to find the path to the Chrome browser.
}
\examples{
\dontrun{
  file <- wordcloud2::demoFreq |>
    make_wordcloud(size = 1.5, display = interactive())

  unlink(file)
}
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
