% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{round_usgs}
\alias{round_usgs}
\title{Round Numbers}
\usage{
round_usgs(x, digits = 0)
}
\arguments{
\item{x}{'numeric' vector.
Value to be rounded.}

\item{digits}{'integer' vector or value.
Number of decimal places to use (default 0).
Values are recycled to match the vector length of \code{x}.}
}
\value{
A numeric vector of rounded values.
}
\description{
Rounds the values in its first argument to the specified number of decimal places.
This function uses the U.S. Geological Survey rounding method.
}
\examples{
inldata::round_usgs(x = rep(pi, 3), digits = c(1, 2, 3))
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{internal}
