% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roads.R
\docType{data}
\name{roads}
\alias{roads}
\title{Road Network}
\format{
A \href{https://r-spatial.github.io/sf/articles/sf1.html}{simple feature} with fields:
\describe{
\item{\code{name}}{Street or road name.}
\item{\code{id}}{Unique identifier.}
\item{\code{route_tp}}{Route type code that describes the type of road where
"M" is the common name,
"O" is other,
"S" is state recognized, and
"U" is United States.}
\item{\code{prisec_fl}}{Whether a road is part of the primary road network.}
\item{\code{geometry}}{Sequence of points connected by straight, non-self-intersecting line pieces,
one-dimensional geometry.}
}
See \code{\link{crs}} dataset for coordinate reference system information.
}
\source{
Spatial line extracts were obtained from the
Master Address File / Topologically Integrated Geographic Encoding and Referencing
(\href{https://www.census.gov/geographies/mapping-files/time-series/geo/tiger-line-file.2022.html#list-tab-ZTNQS959OZX8M0ODED}{MAF/TIGER})
Database (MTDB), 2022 data collection, released September 30, 2022. Which is a part of the
U.S. Department of Commerce, U.S. Census Bureau, Geography Division/Cartographic Products Branch.
These lines were cropped to the study area, and any non-essential data was removed.
}
\usage{
roads
}
\description{
Road network in the vicinity of Idaho National Laboratory, eastern Idaho.
}
\examples{
print(roads)

plot(roads["prisec_fl"])
}
\keyword{datasets}
