#' Descriptive Site Information
#'
#' @description Information for sites in the U.S. Geological Survey (USGS) monitoring networks,
#'   Idaho National Laboratory (INL) and vicinity, Idaho.
#'   The monitoring networks at the INL have evolved to their current 2024 schedules
#'   of monitoring because groundwater and surface-water sites were installed for various reasons;
#'   for example, the need to estimate the volume of the eastern Snake River Plain aquifer,
#'   or to document and understand changes in water quality.
#'   The USGS compiled the list of sites monitored by the USGS using publications by
#'   Knobel and others (2005, table 1) and Bartholomay (2022, table 1).
#'   One well site
#'   (site no. [425812113271201](https://waterdata.usgs.gov/nwis/inventory/?site_no=425812113271201))
#'   was omitted from the dataset because its geographical location falls outside the designated study area.
#'
#' @format A [simple feature](https://r-spatial.github.io/sf/articles/sf1.html) with fields:
#'   \describe{
#'     \item{`site_nm`}{Local site name.}
#'     \item{`station_nm`}{USGS station name with all extra spaces removed from text.
#'       Extra spaces include leading, trailing and in-between spaces
#'       except for a single space character between words.}
#'     \item{`site_no`}{USGS site identification number.}
#'     \item{`coord_meth_cd`}{Latitude/longitude coordinate method code.
#'       The codes and their meanings are as follows:
#'       "C" is surveyed;
#'       "D" is a differentially corrected Global Positioning System (GPS);
#'       "G" mapping grade GPS unit (handheld accuracy range 3.7 to 12.2 meters);
#'       "L" long range navigation system;
#'       "M" interpolated from topographic map;
#'       "N" is not surveyed;
#'       "S" is a transit, theodolite, or other surveying method; and
#'       "X" is not applicable.}
#'     \item{`coord_acy_cd`}{Accuracy code for latitude/longitude values.
#'       The codes and their meanings are as follows:
#'       "1" is accurate to \eqn{\pm}{+/-} 1 second;
#'       "5" is accurate to \eqn{\pm}{+/-} 0.5 second;
#'       "H" is accurate to \eqn{\pm}{+/-} 0.1 second; and
#'       "S" is accurate to \eqn{\pm}{+/-} 1 second.}
#'     \item{`alt_va`}{Elevation of the land surface reference point,
#'       in feet above the North American Vertical Datum of 1988 (NAVD 88).}
#'     \item{`alt_meth_cd`}{Method code for measuring elevation.
#'       The codes and their meanings are as follows:
#'       "D" is a differentially corrected global positioning system,
#'       "L" is a level or other surveyed method, and
#'       "M" is interpolated from a topographic map;
#'       "N" is interpolated from a Digital Elevation Model;
#'       "X" is a GNSS2 - Level 2 Quality Survey Grade Global Navigation Satellite System; and
#'       "Y" is a GNSS3 - Level 3 Quality Survey Grade Global Navigation Satellite System.}
#'     \item{`alt_acy_va`}{Accuracy of the elevation value (`alt_va`), in feet.
#'       Does not account for vertical datum shift.}
#'     \item{`construction_dt`}{Date the well was completed.}
#'     \item{`huc_cd`}{Hydrologic unit code (HUC).
#'       Hydrologic units are geographic areas representing part or all of a surface drainage basin or
#'       distinct hydrologic feature and are delineated on the
#'       [Hydrologic Unit Map](https://water.usgs.gov/GIS/regions.html).
#'       The codes and their meanings are as follows:
#'         "17040201" is the Idaho Falls watershed;
#'         "17040206" is the Portneuf River;
#'         "17040209" is the Blackfoot River;
#'         "17040214" is Beaver-Camas;
#'         "17040215" is the Medicine Lodge Creek;
#'         "17040216" is the Big Lost River;
#'         "17040217" is the Little Lost River; and
#'         "17040218" is Birch Creek.}
#'     \item{`reliability_cd`}{Reliability code for data available for the site.
#'       The codes and their meanings are as follows:
#'         "C" is data that have been checked by the reporting agency;
#'         "M" is minimal data; and
#'         "U" is unchecked data.}
#'     \item{`nat_aqfr_cd`}{National aquifer code where
#'       "N600SKRVPB" is the Snake River Plain basin-fill aquifers, and
#'       "N600SKRVPV" is the Snake River Plain basaltic-rock aquifers.}
#'     \item{`aqfr_cd`}{Aquifer code defined by the catalog of aquifer names and
#'       geologic unit codes used by the Water Mission Area.
#'       The codes and their meanings are as follows:
#'         "100CNZC" is the Cenozoic Erathem, and
#'         "110SKRV" is the Snake River Group.}
#'     \item{`aqfr_type_cd`}{Aquifer type code.
#'       The codes and their meanings are as follows:
#'         "C" is a confined single aquifer,
#'         "M" is confined multiple aquifers,
#'         "U" is an unconfined single aquifer, and
#'         "X" is mixed (confined and unconfined) multiple aquifers.}
#'     \item{`well_depth_va`}{Depth of the finished well, in feet below the land surface datum.}
#'     \item{`hole_depth_va`}{Total depth of the borehole, in feet below the land surface datum.}
#'     \item{`depth_src_cd`}{Source code for depth measurements.
#'       The codes and their meanings are as follows:
#'         "A" is reported by another government agency,
#'         "D" is from driller's log or report,
#'         "G" is reported by a private geologist-consultant or university associate,
#'         "L" is interpreted from geophysical logs by personnel of source agency,
#'         "O" is reported by owner of well,
#'         "R" is reported by person other than the owner, driller, or another government agency,
#'         "S" is measured by personnel of reporting agency; and
#'         "Z" is other source.}
#'     \item{`completion_cd`}{Borehole completion code.
#'       The codes and their meanings are as follows:
#'         "M" is a multilevel completion,
#'         "O" is an open hole completion, and
#'         "P" is an open hole completion prior to multilevel completion.}
#'     \item{`network_cd`}{Monitoring network code.
#'       The codes and their meanings are as follows:
#'         "A" is the aquifer-monitoring network,
#'         "P" is the perched-groundwater monitoring network,
#'         "S" is the surface-water monitoring network.}
#'     \item{`pos`}{Position specifier for site-labels on a map.
#'       Values of 1, 2, 3 and 4, respectively indicate positions below (south), to the left (west) of,
#'       above (north), and to the right (east) of the site coordinates.}
#'     \item{`geometry`}{Zero-dimensional geometry containing a single point.}
#'   }
#'   See [`crs`] dataset for coordinate reference system information.
#'
#' @source USGS site data acquired from the NWIS (U.S. Geological Survey, 2023).
#'   The station name (`station_nm`) for the data was parsed for a more readable name.
#'   A borehole completion code (`completion_cd`),
#'   as well as an aquifer monitoring network code (`network_cd`) were created.
#'   A position specifier for site-labels on a map (`pos`) was also created.
#'   The classes of the columns were specified, and any unnecessary columns were removed.
#'
#' @references Bartholomay, R.C., 2022,
#'   Historical development of the U.S. Geological Survey hydrological monitoring and investigative programs
#'   at the Idaho National Laboratory, Idaho, 2002-2020:
#'   U.S. Geological Survey Open-File Report 2022-1027 (DOE/ID-22256), 54 p.,
#'   \doi{10.3133/ofr20221027}.
#' @references Knobel, L.L., Bartholomay, R.C., and Rousseau, J.P., 2005,
#'   Historical development of the U.S. Geological Survey hydrologic monitoring and investigative programs
#'   at the Idaho National Engineering and Environmental Laboratory, Idaho, 1949 to 2001:
#'   U.S. Geological Survey Open-File Report 2005-1223 (DOE/ID-22195), 93 p.,
#'   \doi{10.3133/ofr20051223}.
#' @references U.S. Geological Survey, 2023, National Water Information System---web services,
#'   accessed April 7, 2023, from \doi{10.5066/F7P55KJN}.
#'
#' @keywords datasets
#'
#' @examples
#' print(sites)
#'
#' plot(sites["network_cd"])
"sites"
