% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotsample.R
\name{plotsample}
\alias{plotsample}
\title{Create a plot sample.}
\usage{
plotsample(spdf, boundary, x.ppn = 0.25, y.ppn = 0.25, nx = 5, ny = 5)
}
\arguments{
\item{spdf}{A \code{SpatialPointsDataFrame} defining the points that are to be sampled
by the plot sample.}

\item{boundary}{A \code{SpatialPolygonsDataFrame} defining the survey boundary within which
the  points occur.}

\item{x.ppn}{The proportion of the x=axis that is to be included in the plots.}

\item{y.ppn}{The proportion of the y=axis that is to be included in the plots.}

\item{nx}{The number of plots in the x-dimension.}

\item{ny}{The number of plots in the y-dimension.}
}
\value{
A list with three components:
\describe{
\item{\code{plots}:}{ A \code{SpatialPolygonsDataFrame} object containing the plots that were
sampled.}
\item{\code{dets}:}{ A \code{SpatialPointsDataFrame} object containing the locations of the
points within the plots.}
\item{\code{counts}:}{ A \code{dataframe} containing the following columns
\describe{
\item{\code{x}:}{The x-coordinates of the centres of the plots within the boundary.}
\item{\code{y}:}{The y-coordinates of the centres of the plots within the boundary.}
\item{\code{n}:}{The numbers of points in each plot.}
\item{\code{area}:}{The areas of the plots within the boundary}
}}
}.
}
\description{
Creates a plot sample on a regular grid with a random start location.
}
\examples{
\donttest{
# Some features require the raster package
if (bru_safe_sp() &&
  require("raster", quietly = TRUE) &&
  require("ggplot2", quietly = TRUE)) {
  data(gorillas, package = "inlabru")
  plotpts <- plotsample(gorillas$nests, gorillas$boundary,
    x.ppn = 0.4, y.ppn = 0.4, nx = 5, ny = 5
  )
  ggplot() +
    gg(plotpts$plots) +
    gg(plotpts$dets, pch = "+", cex = 2) +
    gg(gorillas$boundary)
}
}

}
