% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{evaluate_model}
\alias{evaluate_model}
\alias{evaluate_state}
\title{Evaluate or sample from a posterior result given a model and locations}
\usage{
evaluate_model(
  model,
  state,
  data = NULL,
  A = NULL,
  predictor = NULL,
  format = NULL,
  include = NULL,
  exclude = NULL,
  ...
)

evaluate_state(
  model,
  result,
  property = "mode",
  n = 1,
  seed = 0L,
  num.threads = NULL,
  internal_hyperpar = FALSE,
  ...
)
}
\arguments{
\item{model}{A \link{bru} model}

\item{state}{list of lists, as generated by \code{\link[=evaluate_state]{evaluate_state()}}}

\item{data}{A \code{list}, \code{data.frame}, or \code{Spatial*DataFrame}, with coordinates
and covariates needed to evaluate the predictor.}

\item{A}{Precomputed A-matrices}

\item{predictor}{A formula or an expression to be evaluated given the
posterior or for each sample thereof. The default (\code{NULL}) returns a
\code{data.frame} containing the sampled effects. In case of a formula the right
hand side is used for evaluation.}

\item{format}{character; determines the storage format of predictor output.
Available options:
\itemize{
\item \code{"auto"} If the first evaluated result is a vector or single-column matrix,
the "matrix" format is used, otherwise "list".
\item \code{"matrix"} A matrix where each column contains the evaluated predictor
expression for a state.
\item \code{"list"} A list where each element contains the evaluated predictor
expression for a state.
}}

\item{include}{Character vector of component labels that are needed by the
predictor expression; Default: NULL (include all components that are not
explicitly excluded)}

\item{exclude}{Character vector of component labels that are not used by the
predictor expression. The exclusion list is applied to the list
as determined by the \code{include} parameter; Default: NULL (do not remove
any components from the inclusion list)}

\item{\dots}{Additional arguments passed on to \code{inla.posterior.sample}}

\item{result}{A \code{bru} object from \code{\link[=bru]{bru()}} or \code{\link[=lgcp]{lgcp()}}}

\item{property}{Property of the model components to obtain value from.
Default: "mode". Other options are "mean", "0.025quant", "0.975quant",
"sd" and "sample". In case of "sample" you will obtain samples from the
posterior (see \code{n} parameter). If \code{result} is \code{NULL}, all-zero vectors are
returned for each component.}

\item{n}{Number of samples to draw.}

\item{seed}{If seed != 0L, the random seed}

\item{num.threads}{Specification of desired number of threads for parallel
computations. Default NULL, leaves it up to INLA.
When seed != 0, overridden to "1:1"}

\item{internal_hyperpar}{logical; If \code{TRUE}, return hyperparameter properties
on the internal scale. Currently ignored when \code{property="sample"}.
Default is \code{FALSE}.}
}
\description{
Evaluate or sample from a posterior result given a model and locations
}
\details{
\itemize{
\item \code{evaluate_model} is a wrapper to evaluate model state, A-matrices,
effects, and predictor, all in one call.
}

\itemize{
\item \code{evaluate_state} evaluates model state properties or samples
}
}
\keyword{internal}
